/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.common.Checks;
import org.hansken.plugin.extraction.util.ArgChecks;

public class ExtractionPluginDataReader {
    private final Map<String, Set<String>> _dataAvailable = new HashMap<String, Set<String>>();
    private final Map<String, Map<String, RandomAccessData>> _dataCache = new HashMap<String, Map<String, RandomAccessData>>();
    private final ClientDataContext _context;

    public ExtractionPluginDataReader(ClientDataContext context) {
        this._context = (ClientDataContext)ArgChecks.argNotNull((String)"context", (Object)context);
        if (!Checks.isMetaContext((DataContext)this._context)) {
            this._dataCache.computeIfAbsent("0", k -> new HashMap()).put(this._context.dataType(), this._context.data());
            this._dataAvailable.put("0", Set.of(this._context.dataType()));
        }
    }

    public void markDataAvailable(SearchTrace trace) {
        this._dataAvailable.put((String)trace.get("uid"), new HashSet(trace.getDataTypes()));
    }

    public byte[] read(String traceUid, String dataType, long position, int count) throws IOException {
        if (!this._dataAvailable.containsKey(traceUid)) {
            throw new NoSuchElementException("No data available for trace with uid: " + traceUid);
        }
        Map dataMap = this._dataCache.computeIfAbsent(traceUid, k -> new HashMap());
        if (!this._dataAvailable.get(traceUid).contains(dataType)) {
            throw new NoSuchElementException("No data available for data type: " + dataType);
        }
        RandomAccessData typedData = dataMap.computeIfAbsent(dataType, k -> this._context.data(traceUid, dataType));
        typedData.seek(position);
        return typedData.readNBytes(count);
    }
}

