/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.util.concurrent.CountDownLatch;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.ep.shade.io.grpc.Status;
import org.hansken.ep.shade.io.grpc.stub.StreamObserver;
import org.hansken.extraction.plugin.grpc.RpcFinish;
import org.hansken.extraction.plugin.grpc.RpcPartialFinishWithError;
import org.hansken.extraction.plugin.grpc.RpcStart;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginException;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginGrpcAdapter;
import org.hansken.plugin.extraction.runtime.grpc.client.ReplyStream;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;

public class ProtocolHandler
implements StreamObserver<Any> {
    private final ExtractionPluginGrpcAdapter _adapter;
    private final CountDownLatch _finishLatch;
    private final ReplyStream _replyStream;
    private volatile boolean _started;
    private volatile boolean _finishReceived;

    public ProtocolHandler(ReplyStream replyStream, ExtractionPluginGrpcAdapter adapter) {
        this._adapter = adapter;
        this._replyStream = replyStream;
        this._finishLatch = new CountDownLatch(1);
        this._started = false;
    }

    public void start(Trace trace, DataContext context) {
        try {
            this._started = true;
            this._replyStream.reply(Any.pack(RpcStart.newBuilder().setTrace(Pack.trace((String)"0", (ImmutableTrace)trace)).setDataContext(Pack.metaOfDataContext((DataContext)context)).build()));
        }
        catch (Throwable t) {
            this.setErrorFromInternal(Status.Code.CANCELLED, t);
            throw t;
        }
    }

    public void await() {
        try {
            this._finishLatch.await();
        }
        catch (InterruptedException e) {
            try {
                this.setErrorFromInternal(Status.Code.CANCELLED, e);
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            this.handleFinishErrors();
        }
    }

    @Override
    public void onNext(Any message) {
        try {
            if (!this._started) {
                this._finishLatch.countDown();
                throw new IllegalStateException("received a message from server, but processing of the trace has not been started yet");
            }
            this._adapter.execute(message).ifPresent(this._replyStream::reply);
            if (message.is(RpcFinish.class) || message.is(RpcPartialFinishWithError.class)) {
                this._finishReceived = true;
                this._replyStream.onCompleted();
            }
            this.setPartialFinishError(message);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this._adapter.error(e);
            this._replyStream.onError(Pack.asStatusRuntimeException((Status.Code)Status.Code.ABORTED, (Throwable)e));
        }
        catch (Throwable t) {
            this._adapter.error(t);
            this._replyStream.onError(Pack.asStatusRuntimeException((Status.Code)Status.Code.ABORTED, (Throwable)t));
        }
    }

    @Override
    public void onError(Throwable t) {
        try {
            this._adapter.error(t);
        }
        finally {
            this._finishLatch.countDown();
        }
    }

    @Override
    public void onCompleted() {
        try {
            if (!this._finishReceived) {
                this.onError(new IllegalStateException("finish message has not been received"));
            }
        }
        finally {
            this._finishLatch.countDown();
        }
    }

    private void setErrorFromInternal(Status.Code code, Throwable t) {
        try {
            this._replyStream.onError(Pack.asStatusRuntimeException((Status.Code)code, (Throwable)t));
        }
        finally {
            this.onError(t);
        }
    }

    private void setPartialFinishError(Any message) {
        if (message.is(RpcPartialFinishWithError.class)) {
            RpcPartialFinishWithError partialFinish = (RpcPartialFinishWithError)Unpack.any((Any)message, RpcPartialFinishWithError.class);
            Status.Code code = Status.Code.valueOf(partialFinish.getStatusCode());
            this._adapter.error(ExtractionPluginException.getInstanceWithoutStacktrace(partialFinish.getErrorDescription()), "PartialFinishError. An exception was thrown by the Extraction Plugin.");
        }
    }

    private void handleFinishErrors() {
        this._adapter.error().ifPresent(error -> {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new IllegalStateException((Throwable)error);
        });
    }
}

