/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.util.ArgChecks;

final class StreamTransferState {
    private static final int DEFAULT_BUFFER_SIZE = 32768;
    private static final long TASK_FINISH_WAIT_MS = TimeUnit.SECONDS.toMillis(16L);
    private final Trace _trace;
    private final ExecutorService _executor;
    private final AtomicBoolean _inTransfer;
    private final String _dataType;
    private OutputStream _stream;
    private Future<?> _task;

    private StreamTransferState(Trace trace, String dataType, ExecutorService executor) {
        this._trace = (Trace)ArgChecks.argNotNull((String)"trace", (Object)trace);
        this._executor = (ExecutorService)ArgChecks.argNotNull((String)"executor", (Object)executor);
        this._inTransfer = new AtomicBoolean();
        this._dataType = dataType;
    }

    static StreamTransferState create(Trace trace, String dataType, ExecutorService executor) {
        return new StreamTransferState(trace, dataType, executor);
    }

    void setup() throws IOException {
        PipedInputStream input = new PipedInputStream(32768);
        this._stream = new PipedOutputStream(input);
        this._task = this._executor.submit(() -> {
            try (PipedInputStream pipedInputStream = input;){
                this._trace.setData(this._dataType, (InputStream)input);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    StreamTransferState start() throws IOException {
        this.flagStart();
        return this;
    }

    StreamTransferState write(byte[] data) throws IOException {
        this.assertInitialized();
        this._stream.write(data);
        return this;
    }

    StreamTransferState finish() throws IOException {
        this.assertInitialized();
        this.shutdownAndAwait();
        return this;
    }

    void shutdownAndAwait() throws IOException {
        if (!this._inTransfer.get()) {
            return;
        }
        try {
            this._stream.flush();
            this._stream.close();
            this._task.get(TASK_FINISH_WAIT_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.cleanup();
            this.flagFinish();
        }
    }

    private void cleanup() {
        this._task = null;
        this._stream = null;
    }

    private void flagStart() {
        if (this._inTransfer.getAndSet(true)) {
            throw new IllegalStateException("already writing stream of type: " + this._dataType);
        }
    }

    private void flagFinish() {
        this._inTransfer.set(false);
    }

    private void assertInitialized() {
        if (!this._inTransfer.get()) {
            throw new IllegalStateException("currently not in transfer mode for stream of type: " + this._dataType);
        }
    }
}

