/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import org.hansken.plugin.extraction.util.ArgChecks;

public final class Author {
    private final String _name;
    private final String _email;
    private final String _organisation;

    private Author(String name, String email, String organisation) {
        this._name = ArgChecks.argNotNull("name", name);
        this._email = ArgChecks.argNotNull("email", email);
        this._organisation = ArgChecks.argNotNull("organisation", organisation);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String name() {
        return this._name;
    }

    public String email() {
        return this._email;
    }

    public String organisation() {
        return this._organisation;
    }

    public static final class Builder {
        private String _name;
        private String _email;
        private String _organisation;

        public Builder name(String name) {
            this._name = ArgChecks.argNotEmpty("name", name);
            return this;
        }

        public Builder email(String email) {
            this._email = ArgChecks.argNotEmpty("email", email);
            return this;
        }

        public Builder organisation(String organisation) {
            this._organisation = ArgChecks.argNotEmpty("organisation", organisation);
            return this;
        }

        public Author build() {
            return new Author(this._name, this._email, this._organisation);
        }
    }
}

