/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.util.List;
import org.hansken.plugin.extraction.api.SearchScope;
import org.hansken.plugin.extraction.api.SearchSortOption;

public record SearchOptions(SearchScope scope, int start, List<SearchSortOption> sort) {
    public static final SearchOptions DEFAULT = SearchOptions.builder().build();

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SearchScope _scope = SearchScope.IMAGE;
        private int _start;
        private List<SearchSortOption> _sort = List.of(SearchSortOption.builder().build());

        public Builder scope(SearchScope scope) {
            this._scope = scope;
            return this;
        }

        public Builder offset(int start) {
            this._start = start;
            return this;
        }

        public Builder sort(List<SearchSortOption> sort) {
            this._sort = sort;
            return this;
        }

        public SearchOptions build() {
            return new SearchOptions(this._scope, this._start, this._sort);
        }
    }
}

