/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import org.hansken.plugin.extraction.util.ArgChecks;

public final class Vector {
    private final byte[] _encoded;

    private Vector(byte[] encoded) {
        this._encoded = encoded;
    }

    public static Vector of(float ... values) {
        ArgChecks.argNotNull("values", values);
        ByteBuffer bytes = ByteBuffer.allocate(4 * values.length);
        bytes.asFloatBuffer().put(values);
        return new Vector(bytes.array());
    }

    public static Vector of(Collection<Float> values) {
        ArgChecks.argNotNull("values", values);
        ByteBuffer bytes = ByteBuffer.allocate(4 * values.size());
        FloatBuffer floats = bytes.asFloatBuffer();
        for (Number number : values) {
            floats.put(number.floatValue());
        }
        return new Vector(bytes.array());
    }

    public static Vector ofBase64(String base64) {
        ArgChecks.argNotNull("base64", base64);
        byte[] bytes = Base64.getDecoder().decode(base64);
        return new Vector(bytes);
    }

    public static Vector asVector(byte[] bytes) {
        ArgChecks.argNotNull("bytes", bytes);
        return new Vector(bytes);
    }

    public byte[] asBinary() {
        return this._encoded;
    }

    public int size() {
        return this._encoded.length / 4;
    }

    public float[] values() {
        float[] floats = new float[this.size()];
        ByteBuffer.wrap(this._encoded).asFloatBuffer().get(floats);
        return floats;
    }

    public String toBase64() {
        return Base64.getEncoder().encodeToString(this._encoded);
    }

    public String toString() {
        return this.toBase64();
    }

    public int hashCode() {
        return Arrays.hashCode(this._encoded);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        return Arrays.equals(this._encoded, other._encoded);
    }
}

