/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.util;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

public final class ArgChecks {
    private ArgChecks() {
    }

    public static <T> T argNotNull(String name, T value) {
        if (value == null) {
            throw new NullPointerException(String.format(Locale.ROOT, "argument '%s' cannot be null", name));
        }
        return value;
    }

    public static <T> List<T> argsIsType(String name, List<T> value, Class<?> type) {
        for (T t : value) {
            if (type.isInstance(t)) continue;
            throw new ClassCastException(String.format(Locale.ROOT, "argument '%s' is not of type %s", name, type.getSimpleName()));
        }
        return value;
    }

    public static Object[] argNotAllNull(String name, Object ... values) {
        for (Object o : values) {
            if (o == null) continue;
            return values;
        }
        throw new NullPointerException(String.format(Locale.ROOT, "argument '%s' cannot all be null", name));
    }

    public static <T> T[] argNotEmpty(String name, T[] value) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "argument '%s' cannot be empty", name));
        }
        return value;
    }

    public static <T> Collection<T> argNotEmpty(String name, Collection<T> value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "argument '%s' cannot be empty", name));
        }
        return value;
    }

    public static String argNotEmpty(String name, String value) {
        ArgChecks.argNotNull(name, value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "argument '%s' cannot be empty", name));
        }
        return value;
    }

    public static int argNotNegative(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "argument '%s' cannot be negative: %d", name, value));
        }
        return value;
    }

    public static long argNotNegative(String name, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "argument '%s' cannot be negative: %d", name, value));
        }
        return value;
    }

    public static float argNotNegative(String name, float value) {
        if (value < 0.0f) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "argument '%s' cannot be negative: %d", name, Float.valueOf(value)));
        }
        return value;
    }
}

