/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.FlitsResultValidator;

public final class CombinedResult
implements FlitsResult {
    private final List<FlitsResult> _results;

    private CombinedResult(List<FlitsResult> results) {
        ArgChecks.argNotEmpty("results", results);
        this._results = List.copyOf(results);
    }

    @Deprecated(forRemoval=true)
    public static FlitsResult of(List<FlitsResult> results) {
        ArgChecks.argNotEmpty("results", results);
        return new CombinedResult(results);
    }

    public static CombinedResult of(FlitsResult result1, FlitsResult result2, FlitsResult ... moreResults) {
        return CombinedResult.of(result1, result2, Arrays.asList(moreResults));
    }

    public static CombinedResult of(FlitsResult result1, FlitsResult result2, Collection<FlitsResult> moreResults) {
        ArgChecks.argNotNull("result1", result1);
        ArgChecks.argNotNull("result2", result2);
        ArrayList<FlitsResult> flitsResults = new ArrayList<FlitsResult>(moreResults.size() + 2);
        flitsResults.add(result1);
        flitsResults.add(result2);
        flitsResults.addAll(moreResults);
        return new CombinedResult(flitsResults);
    }

    @Override
    public void validate(FlitsResultValidator validator, Path inputPath) throws IOException {
        validator.validate(this, inputPath);
    }

    @Override
    public void generate(FlitsResultGenerator generator, Path outputPath) throws IOException {
        generator.generate(this, outputPath);
    }

    public List<FlitsResult> results() {
        return this._results;
    }
}

