/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.FlitsResultValidator;
import nl.minvenj.nfi.flits.api.Trace;

public class TraceResult
implements FlitsResult {
    private final List<Trace> _traces;
    private final String _factoryName;

    public TraceResult(Trace trace) {
        this(List.of(ArgChecks.argNotNull("trace", trace)));
    }

    public TraceResult(Trace trace, String factoryName) {
        this(List.of(ArgChecks.argNotNull("trace", trace)), factoryName);
    }

    public TraceResult(List<Trace> traces) {
        this._traces = List.copyOf((Collection)ArgChecks.argNotEmpty("traces", traces));
        this._factoryName = null;
    }

    public TraceResult(List<Trace> traces, String factoryName) {
        this._traces = List.copyOf((Collection)ArgChecks.argNotEmpty("traces", traces));
        this._factoryName = ArgChecks.argNotNull("factoryName", factoryName);
    }

    public List<Trace> traces() {
        return this._traces;
    }

    public Optional<String> factoryName() {
        return Optional.ofNullable(this._factoryName);
    }

    @Override
    public void validate(FlitsResultValidator validator, Path inputPath) throws IOException {
        validator.validate(this, inputPath);
    }

    @Override
    public void generate(FlitsResultGenerator generator, Path outputPath) throws IOException {
        generator.generate(this, outputPath);
    }
}

