/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.base;

import java.io.IOException;
import java.nio.file.Path;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.result.CombinedResult;
import nl.minvenj.nfi.flits.api.result.EmptyResult;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.CombinedResultJson;
import nl.minvenj.nfi.flits.base.EmptyResultJson;
import nl.minvenj.nfi.flits.base.ThrowableResultJson;
import nl.minvenj.nfi.flits.base.TraceResultJson;
import nl.minvenj.nfi.flits.serialize.TraceToJson;

public class DefaultResultGenerator
implements FlitsResultGenerator {
    private final TraceToJson _traceJson;

    public DefaultResultGenerator(TraceToJson traceJson) {
        this._traceJson = ArgChecks.argNotNull("traceJson", traceJson);
    }

    @Override
    public void generate(EmptyResult result, Path outputPath) throws IOException {
        EmptyResultJson resultJson = new EmptyResultJson(result);
        resultJson.toPath(outputPath);
    }

    @Override
    public void generate(ThrowableResult result, Path outputPath) throws IOException {
        ThrowableResultJson resultJson = new ThrowableResultJson(result);
        resultJson.toPath(outputPath);
    }

    @Override
    public void generate(CombinedResult result, Path outputPath) throws IOException {
        CombinedResultJson resultJson = new CombinedResultJson(result, this._traceJson);
        resultJson.toPath(outputPath);
    }

    @Override
    public void generate(TraceResult result, Path outputPath) throws IOException {
        TraceResultJson resultJson = new TraceResultJson(result, this._traceJson);
        resultJson.toPath(outputPath);
    }
}

