/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.base;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.diff.JsonDiff;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.CRC32;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResultValidator;
import nl.minvenj.nfi.flits.api.result.CombinedResult;
import nl.minvenj.nfi.flits.api.result.EmptyResult;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.CombinedResultJson;
import nl.minvenj.nfi.flits.base.EmptyResultJson;
import nl.minvenj.nfi.flits.base.ThrowableResultJson;
import nl.minvenj.nfi.flits.base.TraceResultJson;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import nl.minvenj.nfi.flits.util.FlitsUtil;
import org.junit.jupiter.api.Assertions;

public class DefaultResultValidator
implements FlitsResultValidator {
    private final TraceToJson _traceJson;

    public DefaultResultValidator(TraceToJson traceJson) {
        this._traceJson = ArgChecks.argNotNull("traceJson", traceJson);
    }

    @Override
    public void validate(EmptyResult result, Path inputPath) throws IOException {
        DefaultResultValidator.validate(new EmptyResultJson(result).json(), inputPath);
    }

    @Override
    public void validate(ThrowableResult result, Path inputPath) throws IOException {
        DefaultResultValidator.validate(new ThrowableResultJson(result).json(), inputPath);
    }

    @Override
    public void validate(CombinedResult result, Path inputPath) throws IOException {
        Assertions.assertTrue((boolean)Files.isRegularFile(inputPath, new LinkOption[0]), (String)("No result file found, expected to be located at: " + String.valueOf(inputPath)));
        String json = new CombinedResultJson(result, this._traceJson).json();
        DefaultResultValidator.validate(json, inputPath);
    }

    @Override
    public void validate(TraceResult result, Path inputPath) throws IOException {
        String actualJson = new TraceResultJson(result, this._traceJson).json();
        Assertions.assertTrue((boolean)Files.isRegularFile(inputPath, new LinkOption[0]), (String)("No result file found, expected to be located at: " + String.valueOf(inputPath)));
        try {
            DefaultResultValidator.validate(actualJson, inputPath);
        }
        catch (JsonProcessingException e) {
            DefaultResultValidator.validateLineByLine(actualJson, inputPath);
        }
    }

    private static void validate(String actualJson, Path inputPath) throws IOException {
        Assertions.assertTrue((boolean)Files.isRegularFile(inputPath, new LinkOption[0]), (String)("No result file found, expected to be located at: " + String.valueOf(inputPath)));
        try (InputStream file = Files.newInputStream(inputPath, new OpenOption[0]);){
            long expectedCrcValue = DefaultResultValidator.streamingCrc(file);
            CRC32 actualCrc = new CRC32();
            actualCrc.update(actualJson.getBytes(StandardCharsets.UTF_8));
            if (expectedCrcValue == actualCrc.getValue()) {
                return;
            }
        }
        ObjectMapper jackson = new ObjectMapper();
        try (InputStream inputStream = Files.newInputStream(inputPath, new OpenOption[0]);){
            JsonNode beforeNode = jackson.readTree(inputStream);
            JsonNode afterNode = jackson.readTree(actualJson);
            JsonNode difference = JsonDiff.asJson((JsonNode)beforeNode, (JsonNode)afterNode);
            if (difference.elements().hasNext()) {
                throw new AssertionError((Object)String.format(Locale.ROOT, "Difference found for %s: %n%s", inputPath, DefaultResultValidator.diffPerLine(difference)));
            }
        }
    }

    private static long streamingCrc(InputStream input) throws IOException {
        int nRead;
        CRC32 crc = new CRC32();
        byte[] bytes = new byte[4096];
        while ((nRead = input.read(bytes)) >= 0) {
            crc.update(bytes, 0, nRead);
        }
        return crc.getValue();
    }

    private static String diffPerLine(JsonNode node) {
        return StreamSupport.stream(node.spliterator(), false).limit(1000L).map(JsonNode::toString).collect(Collectors.joining(System.lineSeparator()));
    }

    private static void validateLineByLine(String actualJson, Path inputPath) throws IOException {
        FlitsUtil.assertEquals(Files.lines(inputPath), DefaultResultValidator.splitLines(actualJson));
    }

    private static Stream<String> splitLines(String text) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
            Stream<String> stream = lines.stream();
            return stream;
        }
    }
}

