/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.base;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.DefaultResultValidator;
import nl.minvenj.nfi.flits.base.TraceResultJson;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import nl.minvenj.nfi.flits.util.FlitsUtil;

public class LineStreamingResultValidator
extends DefaultResultValidator {
    private final TraceToJson _traceToJson;

    public LineStreamingResultValidator(TraceToJson traceToJson) {
        super(traceToJson);
        this._traceToJson = traceToJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(TraceResult result, Path inputPath) throws IOException {
        Path tempFile = Files.createTempFile("flits-validate-result", ".txt", new FileAttribute[0]);
        try {
            new TraceResultJson(result, this._traceToJson).toPath(tempFile);
            FlitsUtil.assertEquals(Files.lines(inputPath), Files.lines(tempFile));
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }
}

