/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.Optional;
import java.util.function.Function;
import nl.minvenj.nfi.common.argchecks.ArgChecks;

final class CustomConversion {
    private final TypeSafeConversion<?> _typeSafeConversion;

    private CustomConversion(TypeSafeConversion<?> typeSafeConversion) {
        this._typeSafeConversion = typeSafeConversion;
    }

    static <T> CustomConversion create(Class<T> type, Function<? super T, String> conversion) {
        ArgChecks.argNotNull("type", type);
        ArgChecks.argNotNull("conversion", conversion);
        return new CustomConversion(new TypeSafeConversion<T>(type, conversion));
    }

    Optional<String> tryConvert(Object value) {
        ArgChecks.argNotNull("value", value);
        return this._typeSafeConversion.tryConvert(value);
    }

    private static final class TypeSafeConversion<T> {
        private final Class<T> _type;
        private final Function<? super T, String> _toString;

        TypeSafeConversion(Class<T> type, Function<? super T, String> toString) {
            this._type = type;
            this._toString = toString;
        }

        Optional<String> tryConvert(Object value) {
            if (this._type.isInstance(value)) {
                return Optional.of(this._toString.apply(this._type.cast(value)));
            }
            return Optional.empty();
        }
    }
}

