/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import nl.minvenj.nfi.common.argchecks.ArgChecks;

public class CustomMapConversion {
    private final TypeSafeMap<?> _typeSafeMap;

    private CustomMapConversion(TypeSafeMap<?> typeSafeMap) {
        this._typeSafeMap = typeSafeMap;
    }

    static <T> CustomMapConversion create(Class<T> type, Function<? super T, Map<String, String>> map) {
        ArgChecks.argNotNull("type", type);
        ArgChecks.argNotNull("map", map);
        return new CustomMapConversion(new TypeSafeMap<T>(type, map));
    }

    Optional<Map<String, String>> tryConvert(Object value) {
        ArgChecks.argNotNull("value", value);
        return this._typeSafeMap.tryConvert(value);
    }

    private static final class TypeSafeMap<T> {
        private final Class<T> _type;
        private final Function<? super T, Map<String, String>> _toMap;

        TypeSafeMap(Class<T> type, Function<? super T, Map<String, String>> toMap) {
            this._type = type;
            this._toMap = toMap;
        }

        Optional<Map<String, String>> tryConvert(Object value) {
            if (this._type.isInstance(value)) {
                return Optional.of(this._toMap.apply(this._type.cast(value)));
            }
            return Optional.empty();
        }
    }
}

