/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.Comparator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import nl.minvenj.nfi.flits.api.Trace;
import nl.minvenj.nfi.flits.serialize.Property;

final class CustomOrder {
    private final Predicate<? super Trace> _predicate;
    private final Comparator<? super String> _comparator;

    private CustomOrder(Predicate<? super Trace> predicate, Comparator<? super String> comparator) {
        this._predicate = predicate;
        this._comparator = comparator;
    }

    static CustomOrder create(Predicate<? super Trace> predicate, Comparator<? super String> comparator) {
        return new CustomOrder(predicate, comparator);
    }

    boolean triggersOn(Trace trace) {
        return this._predicate.test(trace);
    }

    Stream<Property> order(Set<Property> properties) {
        return properties.stream().sorted((p1, p2) -> this._comparator.compare(p1.fullName(), p2.fullName()));
    }
}

