/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.util.Arrays;

public final class PlatformIndependentPrettyPrinter
extends DefaultPrettyPrinter {
    private static final long serialVersionUID = -5512586643324525213L;

    public PlatformIndependentPrettyPrinter() {
        this._objectIndenter = new PlatformIndependentSpacesIndenter();
    }

    private static final class PlatformIndependentSpacesIndenter
    extends DefaultPrettyPrinter.NopIndenter {
        private static final String SYS_LF = "\n";
        private static final int SPACE_COUNT = 64;
        private static final char[] SPACES = new char[64];

        private PlatformIndependentSpacesIndenter() {
        }

        public boolean isInline() {
            return false;
        }

        public void writeIndentation(JsonGenerator jg, int level) throws IOException {
            jg.writeRaw(SYS_LF);
            if (level > 0) {
                int spaces;
                for (spaces = level + level; spaces > 64; spaces -= SPACES.length) {
                    jg.writeRaw(SPACES, 0, 64);
                }
                jg.writeRaw(SPACES, 0, spaces);
            }
        }

        static {
            Arrays.fill(SPACES, ' ');
        }
    }
}

