/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import nl.minvenj.nfi.common.argchecks.ArgChecks;

final class Property {
    private final String _type;
    private final String _name;
    private final String _fullName;

    private Property(String type, String name, String fullName) {
        this._type = type;
        this._name = name;
        this._fullName = fullName;
    }

    static Property parse(String property) {
        String[] parts = ArgChecks.argNotNull("property", property).split("\\.", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Property should be of the format [type].[name]: " + property);
        }
        return new Property(parts[0], parts[1], property);
    }

    String type() {
        return this._type;
    }

    String name() {
        return this._name;
    }

    String fullName() {
        return this._fullName;
    }
}

