/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hansken.plugin.extraction.api.DataWriter;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.client.PluginRunProfile;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.hansken.plugin.extraction.util.ThrowingConsumer;

final class TraceDelegate {
    private TraceDelegate() {
    }

    public static EmbeddedTraceDelegate forEmbeddedTrace(Trace trace) {
        return new EmbeddedTraceDelegate(trace);
    }

    public static ClientTraceDelegate forClientTrace(ClientTrace trace) {
        return new ClientTraceDelegate(trace);
    }

    static class EmbeddedTraceDelegate
    implements nl.minvenj.nfi.flits.api.Trace,
    Trace {
        protected final List<nl.minvenj.nfi.flits.api.Trace> _children;
        private final Trace _delegate;
        private PluginRunProfile _profile;

        EmbeddedTraceDelegate(Trace trace) {
            this._delegate = (Trace)ArgChecks.argNotNull((String)"trace", (Object)trace);
            this._children = new ArrayList<nl.minvenj.nfi.flits.api.Trace>();
        }

        public String traceId() {
            return this._delegate.traceId();
        }

        @Override
        public Set<String> types() {
            return this._delegate.types();
        }

        public Trace addType(String s) {
            this._delegate.addType(s);
            return this;
        }

        @Override
        public Set<String> properties() {
            return this._delegate.properties();
        }

        @Override
        public <T> T get(String property) {
            return (T)this._delegate.get(property);
        }

        public Trace set(String property, Object value) {
            this._delegate.set(property, value);
            return this;
        }

        public Trace addTracelet(Trace.Tracelet tracelet) {
            this._delegate.addTracelet(tracelet);
            return this;
        }

        public List<Trace.Tracelet> getNewTracelets() {
            return this._delegate.getNewTracelets();
        }

        public Trace setData(String dataType, DataWriter writer) throws IOException {
            this._delegate.setData(dataType, writer);
            return this;
        }

        public Trace setData(String dataType, List<DataTransformation> transformations) {
            this._delegate.setData(dataType, transformations);
            return this;
        }

        public Trace newChild(String name, ThrowingConsumer<Trace, IOException> enrichChildCallback) throws IOException {
            this._delegate.newChild(name, child -> {
                EmbeddedTraceDelegate delegateChild = TraceDelegate.forEmbeddedTrace(child);
                enrichChildCallback.accept((Object)delegateChild);
                this._children.add(delegateChild);
            });
            return this;
        }

        @Override
        public Stream<nl.minvenj.nfi.flits.api.Trace> children() {
            return this._children.stream();
        }

        public void profile(PluginRunProfile profile) {
            this._profile = profile;
        }

        public Optional<PluginRunProfile> profile() {
            return Optional.ofNullable(this._profile);
        }
    }

    static class ClientTraceDelegate
    implements ClientTrace {
        private final ClientTrace _delegate;
        private final ClientTraceDelegate _parent;
        private final EmbeddedTraceDelegate _embeddedDelegate;

        ClientTraceDelegate(ClientTraceDelegate parent, ClientTrace trace) {
            this._parent = parent;
            this._delegate = trace;
            this._embeddedDelegate = new EmbeddedTraceDelegate((Trace)trace);
        }

        ClientTraceDelegate(ClientTrace trace) {
            this(null, trace);
        }

        public EmbeddedTraceDelegate getEmbeddedDelegate() {
            return this._embeddedDelegate;
        }

        public String name() {
            return this._delegate.name();
        }

        public Trace addType(String type) {
            this._embeddedDelegate.addType(type);
            return this;
        }

        public Trace set(String name, Object value) {
            this._embeddedDelegate.set(name, value);
            return this;
        }

        public Trace addTracelet(Trace.Tracelet tracelet) {
            this._embeddedDelegate.addTracelet(tracelet);
            return this;
        }

        public List<Trace.Tracelet> getNewTracelets() {
            return this._embeddedDelegate.getNewTracelets();
        }

        public Trace setData(String dataType, DataWriter writer) throws IOException {
            this._embeddedDelegate.setData(dataType, writer);
            return this;
        }

        public Trace setData(String dataType, List<DataTransformation> transformation) {
            this._embeddedDelegate.setData(dataType, transformation);
            return this;
        }

        public Trace newChild(String name, ThrowingConsumer<Trace, IOException> enrichChildCallback) {
            throw new UnsupportedOperationException("implementation of a client trace does not support creating children by using a callback");
        }

        public ClientTrace newChild(String name) {
            return new ClientTraceDelegate(this, this._delegate.newChild(name));
        }

        public void close() throws Exception {
            super.close();
        }

        public void save() {
            this._parent._embeddedDelegate._children.add(this._embeddedDelegate);
        }

        public void profile(PluginRunProfile profile) {
            this._embeddedDelegate.profile(profile);
        }

        public Optional<PluginRunProfile> profile() {
            return this._embeddedDelegate.profile();
        }

        public String traceId() {
            return this._embeddedDelegate.traceId();
        }

        public Set<String> types() {
            return this._embeddedDelegate.types();
        }

        public Set<String> properties() {
            return this._embeddedDelegate.properties();
        }

        public <T> T get(String name) {
            return this._embeddedDelegate.get(name);
        }
    }
}

