/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.serialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.logging.log4j.core.util.FileUtils;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.test.TestFrameworkException;
import org.hansken.plugin.extraction.test.base.ProcessingUtil;
import org.hansken.plugin.extraction.test.serialize.RandomAccessFileData;
import org.hansken.plugin.extraction.test.serialize.TestContext;
import org.hansken.plugin.extraction.test.serialize.TestSearchTrace;
import org.hansken.plugin.extraction.test.serialize.TestTrace;
import org.hansken.plugin.extraction.test.serialize.TestTraceSearcher;
import org.hansken.plugin.extraction.test.util.TestResourceUtil;

public final class Deserialize {
    static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PATH = "path";
    private static final String DEFAULT_ID = "0";
    private static final String DEFAULT_NAME = "test-input-trace";
    private static final String DEFAULT_PATH = "/test-input-trace";
    private static final TypeReference<Map<String, Map<String, Object>>> TRACE_JSON_VALUE_TYPE = new TypeReference<Map<String, Map<String, Object>>>(){};

    private Deserialize() {
    }

    public static ClientTrace traceFromJson(Path jsonFile) {
        Map<String, Map<String, Object>> traceProperties = Deserialize.readTraceFromJSON(jsonFile);
        return Deserialize.createTraceErrorHandler(jsonFile, () -> Deserialize.createTrace(traceProperties));
    }

    public static SearchTrace searchTraceFromJson(Path jsonFile) throws IOException {
        Map<String, Map<String, Object>> traceData = Deserialize.readTraceFromJSON(jsonFile);
        return Deserialize.createTraceErrorHandler(jsonFile, () -> Deserialize.createSearchTrace(traceData, jsonFile));
    }

    static Trace traceFromJson(String json) {
        return (Trace)Deserialize.createTraceErrorHandler(null, () -> Deserialize.createTrace((Map)OBJECT_MAPPER.readValue(json, TRACE_JSON_VALUE_TYPE)));
    }

    private static Map<String, Map<String, Object>> readTraceFromJSON(Path jsonFile) {
        Deserialize.testFileCanBeRead(jsonFile);
        try {
            return (Map)OBJECT_MAPPER.readValue(jsonFile.toFile(), TRACE_JSON_VALUE_TYPE);
        }
        catch (Exception e) {
            throw new TestFrameworkException("The test framework can not read the input trace " + TestResourceUtil.relativePathToWorkingDir(jsonFile) + "\n> Most likely, the input trace file is not valid JSON.", e);
        }
    }

    private static <V> V createTraceErrorHandler(Path traceFile, Callable<V> callable) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            StringBuilder explanation = new StringBuilder();
            explanation.append("The test framework could not create a trace from the input trace JSON");
            if (traceFile != null) {
                explanation.append(" file ").append(TestResourceUtil.relativePathToWorkingDir(traceFile));
            }
            explanation.append("\n");
            if (e instanceof TestFrameworkException) {
                explanation.append(" > ").append(e.getMessage()).append("\n\n").append("Please update the trace input file and run the test again.\n").append("The extraction plugin SDK documentation describes in more detail how test traces and data can be defined.");
                throw new TestFrameworkException(explanation.toString(), e.getCause());
            }
            explanation.append("Most likely, the trace JSON contains incorrect invalid values.\n").append("The extraction plugin SDK documentation describes in more detail how trace files can be defined.\n").append("Please update the trace input file and run the test again.");
            throw new TestFrameworkException(explanation.toString(), e);
        }
    }

    private static ClientTrace createTrace(Map<String, Map<String, Object>> deserialized) {
        HashSet<String> types = new HashSet<String>();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map<String, Object> inputTrace = Deserialize.parseInputTrace(deserialized, types, properties);
        String inputTraceId = Deserialize.readStringIntrinsicProperty(ID, DEFAULT_ID, inputTrace);
        String inputTraceName = Deserialize.readStringIntrinsicProperty(NAME, DEFAULT_NAME, inputTrace);
        String inputTracePath = Deserialize.readStringIntrinsicProperty(PATH, DEFAULT_PATH, inputTrace);
        return new TestTrace(inputTraceId, inputTraceName, inputTracePath, types, properties);
    }

    private static SearchTrace createSearchTrace(Map<String, Map<String, Object>> deserialized, Path tracePath) {
        HashSet<String> types = new HashSet<String>();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Map<String, Object> inputTrace = Deserialize.parseInputTrace(deserialized, types, properties);
        Map<String, RandomAccessData> data = Deserialize.getAllData(Deserialize.getDataPaths(tracePath));
        properties.put("image", "0-0-0-0-0");
        return new TestSearchTrace((String)inputTrace.getOrDefault(ID, Deserialize.pathToTraceId(tracePath)), types, properties, data);
    }

    private static String pathToTraceId(Path path) {
        return String.valueOf(path.toAbsolutePath().normalize().hashCode());
    }

    private static String readStringIntrinsicProperty(String property, String defaultValue, Map<String, Object> inputTrace) {
        try {
            return (String)inputTrace.getOrDefault(property, defaultValue);
        }
        catch (ClassCastException e) {
            String actualClass = inputTrace.get(property).getClass().getSimpleName();
            throw new TestFrameworkException("The trace property '" + property + "' must be of type String, but is of type " + actualClass + ".");
        }
    }

    private static void addProperties(Map<String, Object> properties, String type, Map<String, Object> value) {
        value.forEach((propertyName, propertyValue) -> {
            String fullPropertyName = type + "." + propertyName;
            if (propertyValue instanceof Map) {
                Deserialize.addProperties(properties, fullPropertyName, (Map)propertyValue);
                return;
            }
            properties.put(fullPropertyName, propertyValue);
        });
    }

    public static ClientDataContext contextFromRandomAccessData(Path dataFile) throws IOException {
        Deserialize.testFileCanBeRead(dataFile);
        try {
            return new TestContext(dataFile);
        }
        catch (TestFrameworkException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestFrameworkException("The test framework is unable to create test context for data file " + TestResourceUtil.relativePathToWorkingDir(dataFile), e);
        }
    }

    public static TraceSearcher traceSearcherFromData(Path tracePath) {
        return new TestTraceSearcher(tracePath);
    }

    public static String extractDataType(Path dataFilePath) {
        String fileName = dataFilePath.toString();
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }

    private static Map<String, Object> parseInputTrace(Map<String, Map<String, Object>> deserialized, Set<String> types, Map<String, Object> properties) {
        if (!deserialized.containsKey("trace")) {
            throw new TestFrameworkException("The trace JSON does not contain a trace object.");
        }
        Map<String, Object> inputTrace = deserialized.get("trace");
        inputTrace.forEach((type, value) -> {
            if (value instanceof Map) {
                types.add((String)type);
                Deserialize.addProperties(properties, type, (Map)value);
            } else {
                properties.put((String)type, value);
            }
        });
        return inputTrace;
    }

    private static Map<String, RandomAccessData> getAllData(List<Path> dataPaths) {
        return dataPaths.stream().collect(Collectors.toMap(Deserialize::extractDataType, Deserialize::getData));
    }

    private static List<Path> getDataPaths(Path tracePath) {
        String traceFileName = ProcessingUtil.extractFileName(tracePath);
        return Arrays.stream(tracePath.getParent().toFile().listFiles()).filter(file -> !FileUtils.getFileExtension((File)file).equals("trace")).map(File::toPath).filter(path -> ProcessingUtil.extractFileName(path).equals(traceFileName)).collect(Collectors.toList());
    }

    private static RandomAccessData getData(Path path) {
        Deserialize.testFileCanBeRead(path);
        try {
            return new RandomAccessFileData(path.toFile());
        }
        catch (IOException e) {
            throw new TestFrameworkException("The test framework is unable to read the trace data file " + TestResourceUtil.relativePathToWorkingDir(path), e);
        }
    }

    private static void testFileCanBeRead(Path file) {
        if (!file.toFile().exists()) {
            throw new TestFrameworkException("The test framework is unable to open the test file " + TestResourceUtil.relativePathToWorkingDir(file) + "\n> It seems the file does not exist.");
        }
        if (!file.toFile().isFile()) {
            throw new TestFrameworkException("The test framework is unable to open the test file " + TestResourceUtil.relativePathToWorkingDir(file) + "\n> It seems the file is not an actual file.");
        }
        if (!file.toFile().canRead()) {
            throw new TestFrameworkException("The test framework is unable to open the test file " + TestResourceUtil.relativePathToWorkingDir(file) + "\n> Most likely, the input trace file has incorrect file permissions.");
        }
    }
}

