/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.util;

import java.util.Locale;
import java.util.stream.Collectors;
import org.hansken.plugin.extraction.main.StandaloneTestRunner;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;

public final class HqlLogger {
    public static final String HQL_MATCH_MESSAGE = "HQL match found for:";
    public static final String HQL_NO_MATCH_MESSAGE = "HQL did NOT match for:";
    private static final String HQL_MESSAGE = "%n%s%nWith trace:%n%s%n";

    private HqlLogger() {
    }

    public static void logTrace(ClientTrace trace, String dataType, String hqlMatcher, String messagePrefix, boolean verboseLoggingEnabled) {
        if (verboseLoggingEnabled || StandaloneTestRunner.isVerboseEnabled()) {
            System.out.println(HqlLogger.logTrace(trace, dataType, hqlMatcher, messagePrefix));
        }
    }

    static String logTrace(ClientTrace trace, String dataType, String hqlMatcher, String messagePrefix) {
        StringBuilder builder = new StringBuilder();
        builder.append("dataType=").append(dataType).append("\n");
        String types = String.join((CharSequence)", ", trace.types());
        builder.append("types={").append(types).append("}\n");
        String properties = trace.properties().stream().map(key -> key + "=" + trace.get(key).toString()).collect(Collectors.joining(", "));
        builder.append("properties={").append(properties).append("}\n");
        return String.format(Locale.ROOT, messagePrefix + HQL_MESSAGE, hqlMatcher, builder);
    }
}

