/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public final class TestResourceUtil {
    private TestResourceUtil() {
    }

    public static Path getTestResource(String relativePath) throws URISyntaxException {
        URL url = Objects.requireNonNull(TestResourceUtil.class.getResource("/"));
        File root = new File(url.toURI()).getParentFile().getParentFile();
        return Paths.get(root.toString(), "src", "test", "resources", relativePath);
    }

    public static String relativePathToWorkingDir(Path pathToRelative) {
        URI currentAbsolutePath = Paths.get("", new String[0]).toAbsolutePath().toUri();
        URI relativeTestFile = currentAbsolutePath.relativize(pathToRelative.toUri());
        return relativeTestFile.toString();
    }
}

