/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.hql_lite.lang.human.matcher;

import java.util.Objects;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.matcher.HqlMatcherUtil;

class DataTypeHqlMatcher
implements HqlMatcher {
    private final String _value;
    private final boolean _fullMatch;

    DataTypeHqlMatcher(String value, boolean fullMatch) {
        this._value = value;
        this._fullMatch = fullMatch;
    }

    @Override
    public boolean match(ImmutableTrace trace, String dataType) {
        return HqlMatcherUtil.matchStringValuesWithWildcards(this._value, dataType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTypeHqlMatcher that = (DataTypeHqlMatcher)o;
        return this._fullMatch == that._fullMatch && Objects.equals(this._value, that._value);
    }

    public int hashCode() {
        return Objects.hash(this._value, this._fullMatch);
    }
}

