/*
 * Decompiled with CFR 0.152.
 */
package uk.co.datumedge.hamcrest.json;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.co.datumedge.hamcrest.json.JSONArrayComparatorFactory;
import uk.co.datumedge.hamcrest.json.JSONAssertComparator;
import uk.co.datumedge.hamcrest.json.JSONComparisonResult;
import uk.co.datumedge.hamcrest.json.JSONModalComparator;
import uk.co.datumedge.hamcrest.json.JSONObjectComparatorFactory;
import uk.co.datumedge.hamcrest.json.StringComparatorFactory;

public final class SameJSONAs<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final T expected;
    private final JSONModalComparator<T> comparator;

    public SameJSONAs(T expected, JSONModalComparator<T> comparator) {
        this.expected = expected;
        this.comparator = comparator;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.expected.toString());
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        try {
            JSONComparisonResult result = this.comparator.compare(this.expected, actual);
            if (result.failed()) {
                mismatchDescription.appendDescriptionOf((SelfDescribing)result);
            }
            return result.passed();
        }
        catch (JSONException e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            mismatchDescription.appendText(out.toString());
            return false;
        }
    }

    public SameJSONAs<T> allowingAnyArrayOrdering() {
        return new SameJSONAs<T>(this.expected, this.comparator.butAllowingAnyArrayOrdering());
    }

    public SameJSONAs<T> allowingExtraUnexpectedFields() {
        return new SameJSONAs<T>(this.expected, this.comparator.butAllowingExtraUnexpectedFields());
    }

    public static SameJSONAs<JSONObject> sameJSONObjectAs(JSONObject expected) {
        return new SameJSONAs<JSONObject>(expected, JSONAssertComparator.modalComparatorFor(JSONObjectComparatorFactory.jsonObjectComparison()));
    }

    public static SameJSONAs<JSONObject> sameJSONObjectAs(JSONObject expected, JSONModalComparator<JSONObject> comparator) {
        return new SameJSONAs<JSONObject>(expected, comparator);
    }

    public static SameJSONAs<JSONArray> sameJSONArrayAs(JSONArray expected) {
        return new SameJSONAs<JSONArray>(expected, JSONAssertComparator.modalComparatorFor(JSONArrayComparatorFactory.jsonArrayComparison()));
    }

    public static SameJSONAs<? super JSONArray> sameJSONArrayAs(JSONArray expected, JSONModalComparator<JSONArray> comparator) {
        return new SameJSONAs<JSONArray>(expected, comparator);
    }

    public static SameJSONAs<? super String> sameJSONAs(String expected) {
        return new SameJSONAs<String>(expected, JSONAssertComparator.modalComparatorFor(StringComparatorFactory.stringComparison()));
    }

    public static SameJSONAs<? super String> sameJSONAs(String expected, JSONModalComparator<String> comparator) {
        return new SameJSONAs<String>(expected, comparator);
    }
}

