package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.nio.file.Path;

import nl.minvenj.nfi.flits.api.FlitsResultValidator;
import nl.minvenj.nfi.flits.api.Trace;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.LineStreamingResultValidator;
import nl.minvenj.nfi.flits.serialize.TraceToJson;

/**
 * {@link FlitsResultValidator Validator} which fully serializes the {@link Trace} to a {@code JSON} file
 * using a given {@link TraceToJson}, and compares it line by line to a single input file.
 *
 * @author Netherlands Forensic Institute
 */
public class LineStreamingPluginResultValidator extends LineStreamingResultValidator {

    /**
     * Create a FlitsResultValidator using a given {@link TraceToJson} for generating the {@code JSON} representation.
     *
     * @param traceToJson the serializer to use
     */
    public LineStreamingPluginResultValidator(final TraceToJson traceToJson) {
        super(traceToJson);
    }

    @Override
    public void validate(final ThrowableResult result, final Path inputPath) throws IOException {
        if (!PluginThrowableResult.isValidUsingCustomMatching(result, inputPath)) {
            super.validate(result, inputPath);
        }
    }

    @Override
    public void validate(final TraceResult result, final Path inputPath) throws IOException {
        super.validate(result, inputPath);
    }
}
