/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import nl.minvenj.nfi.flits.serialize.Property;

final class MapUtil {
    private MapUtil() {
    }

    static Map<String, Object> mapMap(Map<Property, Object> properties, int depth) {
        HashMap<String, Object> mapOfMaps = new HashMap<String, Object>();
        Set<Property> mapProperties = properties.keySet();
        Set mapNames = mapProperties.stream().map(MapUtil::getMapNamePrefix).collect(Collectors.toSet());
        for (String name : mapNames) {
            String elementName = (depth == 0 ? "ROOT_ELEMENT." : "") + name;
            HashMap<Property, Object> nestedMap = new HashMap<Property, Object>();
            HashMap<String, Object> mapEntries = new HashMap<String, Object>();
            for (Property property : mapProperties) {
                if (!property.fullName().startsWith(name + ".")) continue;
                String mapPostfixName = MapUtil.getMapNamePostfix(property);
                if (mapPostfixName.contains(".")) {
                    nestedMap.put(Property.parse(mapPostfixName), properties.get(property));
                    continue;
                }
                mapEntries.put(mapPostfixName, properties.get(property));
            }
            if (!mapEntries.isEmpty()) {
                mapOfMaps.put(elementName, mapEntries);
            }
            if (nestedMap.isEmpty()) continue;
            mapOfMaps.put(elementName, MapUtil.mapMap(nestedMap, depth + 1));
        }
        return mapOfMaps;
    }

    private static String getMapNamePrefix(Property property) {
        int endIndex = property.fullName().indexOf(".");
        return property.fullName().substring(0, endIndex);
    }

    static String getMapNamePostfix(Property property) {
        int beginIndex = property.fullName().indexOf(".");
        return property.fullName().substring(beginIndex + 1);
    }
}

