/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.plugin.extraction.api.BaseExtractionPlugin;
import org.hansken.plugin.extraction.api.DataContext;
import org.hansken.plugin.extraction.api.DeferredExtractionPlugin;
import org.hansken.plugin.extraction.api.ExtractionPlugin;
import org.hansken.plugin.extraction.api.ImmutableTrace;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.hql_lite.lang.human.HqlLiteHumanQueryParser;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginClient;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.hansken.plugin.extraction.test.ExtractionPluginProcessor;
import org.hansken.plugin.extraction.test.TestFrameworkException;
import org.hansken.plugin.extraction.test.base.TraceDelegate;
import org.hansken.plugin.extraction.test.serialize.Deserialize;
import org.hansken.plugin.extraction.test.serialize.MetaTestContext;
import org.hansken.plugin.extraction.test.serialize.TestTrace;
import org.hansken.plugin.extraction.test.util.HqlLogger;
import org.hansken.plugin.extraction.test.util.TestResourceUtil;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.opentest4j.AssertionFailedError;

public abstract class DefaultExtractionPluginProcessor
implements ExtractionPluginProcessor {
    protected final PluginInfo _info;

    private DefaultExtractionPluginProcessor(BaseExtractionPlugin plugin) {
        this._info = Unpack.pluginInfo((RpcPluginInfo)Pack.pluginInfo((PluginInfo)((BaseExtractionPlugin)ArgChecks.argNotNull((String)"plugin", (Object)plugin)).pluginInfo()));
    }

    @Override
    public String name() {
        if (this._info.id() != null) {
            return this._info.id().name();
        }
        return this._info.name();
    }

    @Override
    public Optional<FlitsResult> process(Path inputPath, Path relativePath) throws IOException {
        try {
            String fileName = inputPath.getFileName().toString();
            switch (this._info.pluginType()) {
                case EXTRACTION_PLUGIN: {
                    return this.processPlugin(inputPath, fileName);
                }
                case DEFERRED_EXTRACTION_PLUGIN: {
                    return this.processDeferredPlugin(inputPath, fileName);
                }
                case META_EXTRACTION_PLUGIN: {
                    return this.processMetaPlugin(inputPath);
                }
            }
            throw new AssertionError((Object)("unknown type of plugin: " + this._info.pluginType()));
        }
        catch (Exception e) {
            System.err.println("The extraction plugin test framework failed running the test for " + TestResourceUtil.relativePathToWorkingDir(inputPath));
            System.err.println();
            if (e instanceof TestFrameworkException) {
                DefaultExtractionPluginProcessor.printTestFrameworkException((TestFrameworkException)e);
            } else {
                DefaultExtractionPluginProcessor.printException(e);
            }
            System.err.println();
            System.err.println("-------------------------------------------------");
            System.err.println("The following lines can be ignored:");
            throw new AssertionFailedError();
        }
    }

    private static void printException(Exception exception) {
        System.err.println("We can't give a clear description on why the test failed, but the following information could give some details on the failure:");
        exception.printStackTrace();
    }

    private static void printTestFrameworkException(TestFrameworkException exception) {
        if (exception.getMessage() != null) {
            System.err.println("Cause of the failure:");
            System.err.println(exception.getMessage());
            System.err.println();
        }
        System.err.println("> Please create a Hansken extraction plugin SDK bug report if you think this failure is incorrect.");
        if (exception.getCause() != null && exception.getCause().getMessage() != null) {
            System.err.println();
            System.err.println("-------------------------------------------------");
            System.err.println("The following lines could give some more details on the failure:");
            System.err.println();
            System.err.println(exception.getCause().getMessage());
        }
    }

    private Optional<FlitsResult> processPlugin(Path inputPath, String fileName) throws Exception {
        String fileNameWithoutType = fileName.substring(0, fileName.lastIndexOf(46));
        Path tracePath = inputPath.resolveSibling(fileNameWithoutType + ".trace");
        try (ClientTrace trace = this.getTrace(tracePath);){
            ClientDataContext context = Deserialize.contextFromRandomAccessData(inputPath);
            Optional<FlitsResult> optional = this.process(trace, context);
            return optional;
        }
    }

    private Optional<FlitsResult> processDeferredPlugin(Path inputPath, String fileName) throws Exception {
        String fileNameWithoutType = fileName.substring(0, fileName.lastIndexOf(46));
        Path tracePath = inputPath.resolveSibling(fileNameWithoutType + ".trace");
        try (ClientTrace trace = this.getTrace(tracePath);){
            ClientDataContext context = Deserialize.contextFromRandomAccessData(inputPath);
            TraceSearcher searcher = Deserialize.traceSearcherFromData(inputPath);
            Optional<FlitsResult> optional = this.processDeferred(trace, context, searcher);
            return optional;
        }
    }

    private Optional<FlitsResult> processMetaPlugin(Path inputPath) throws Exception {
        try (ClientTrace trace = this.getTrace(inputPath);){
            Optional<FlitsResult> optional = this.process(trace, new MetaTestContext(inputPath));
            return optional;
        }
    }

    private ClientTrace getTrace(Path tracePath) {
        return Files.exists(tracePath, new LinkOption[0]) && !DefaultExtractionPluginProcessor.isSearchTrace(tracePath) ? Deserialize.traceFromJson(tracePath) : new TestTrace("test-input-trace");
    }

    public static DefaultExtractionPluginProcessor embedded(ExtractionPlugin plugin, boolean verboseLoggingEnabled) {
        return DefaultExtractionPluginProcessor.processor((BaseExtractionPlugin)plugin, verboseLoggingEnabled);
    }

    public static DefaultExtractionPluginProcessor embedded(DeferredExtractionPlugin plugin, boolean verboseLoggingEnabled) {
        return DefaultExtractionPluginProcessor.processor((BaseExtractionPlugin)plugin, verboseLoggingEnabled);
    }

    private static DefaultExtractionPluginProcessor processor(final BaseExtractionPlugin plugin, final boolean verboseLoggingEnabled) {
        return new DefaultExtractionPluginProcessor(plugin){

            @Override
            public Optional<FlitsResult> process(ClientTrace trace, ClientDataContext context) {
                try {
                    if (!this.isHqlMatch(trace, (DataContext)context, verboseLoggingEnabled)) {
                        return Optional.empty();
                    }
                    TraceDelegate.EmbeddedTraceDelegate delegate = TraceDelegate.forEmbeddedTrace((Trace)trace);
                    if (!(plugin instanceof ExtractionPlugin)) {
                        throw new IllegalArgumentException("Provided plugin is not an implementation of ExtractionPlugin.");
                    }
                    ((ExtractionPlugin)plugin).process((Trace)delegate, (DataContext)context);
                    return Optional.of(new TraceResult(delegate));
                }
                catch (Throwable t) {
                    return Optional.of(new ThrowableResult(t));
                }
            }

            @Override
            public Optional<FlitsResult> processDeferred(ClientTrace trace, ClientDataContext context, TraceSearcher searcher) {
                try {
                    if (!this.isHqlMatch(trace, (DataContext)context, verboseLoggingEnabled)) {
                        return Optional.empty();
                    }
                    TraceDelegate.EmbeddedTraceDelegate delegate = TraceDelegate.forEmbeddedTrace((Trace)trace);
                    if (!(plugin instanceof DeferredExtractionPlugin)) {
                        throw new IllegalArgumentException("Provided plugin is not an implementation of DeferredExtractionPlugin.");
                    }
                    ((DeferredExtractionPlugin)plugin).process((Trace)delegate, (DataContext)context, searcher);
                    return Optional.of(new TraceResult(delegate));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return Optional.of(new ThrowableResult(e));
                }
                catch (Throwable t) {
                    return Optional.of(new ThrowableResult(t));
                }
            }
        };
    }

    public static DefaultExtractionPluginProcessor remote(final ExtractionPluginClient client, final boolean verboseLoggingEnabled) {
        return new DefaultExtractionPluginProcessor((BaseExtractionPlugin)client){

            @Override
            public Optional<FlitsResult> process(ClientTrace trace, ClientDataContext context) {
                try {
                    if (!this.isHqlMatch(trace, (DataContext)context, verboseLoggingEnabled)) {
                        return Optional.empty();
                    }
                    TraceDelegate.ClientTraceDelegate delegate = TraceDelegate.forClientTrace(trace);
                    client.process((ClientTrace)delegate, context);
                    return Optional.of(new TraceResult(delegate));
                }
                catch (Throwable t) {
                    return Optional.of(new ThrowableResult(t));
                }
            }

            @Override
            public Optional<FlitsResult> processDeferred(ClientTrace trace, ClientDataContext context, TraceSearcher searcher) {
                try {
                    if (!this.isHqlMatch(trace, (DataContext)context, verboseLoggingEnabled)) {
                        return Optional.empty();
                    }
                    TraceDelegate.ClientTraceDelegate delegate = TraceDelegate.forClientTrace(trace);
                    client.processDeferred((ClientTrace)delegate, context, searcher);
                    return Optional.of(new TraceResult(delegate));
                }
                catch (Throwable t) {
                    return Optional.of(new ThrowableResult(t));
                }
            }
        };
    }

    protected boolean isHqlMatch(ClientTrace trace, DataContext context, boolean verboseLoggingEnabled) {
        String hqlMatcher = this._info.hqlMatcher();
        String dataType = context.dataType();
        if (!HqlLiteHumanQueryParser.parse((String)this._info.hqlMatcher(), (String)VersionUtil.getApiVersion()).match((ImmutableTrace)trace, context.dataType())) {
            HqlLogger.logTrace(trace, dataType, hqlMatcher, "HQL did NOT match for:", verboseLoggingEnabled);
            return false;
        }
        HqlLogger.logTrace(trace, dataType, hqlMatcher, "HQL match found for:", verboseLoggingEnabled);
        return true;
    }

    static boolean isSearchTrace(Path tracePath) {
        String parentFolderName = tracePath.getParent().getFileName().toString();
        return parentFolderName.equals("searchtraces");
    }
}

