/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.api;

import java.util.Locale;
import java.util.Objects;

public class LatLong {
    private final double _latitude;
    private final double _longitude;

    protected LatLong(double latitude, double longitude) {
        this._latitude = latitude;
        this._longitude = longitude;
    }

    public static LatLong of(double latitude, double longitude) {
        return new LatLong(latitude, longitude);
    }

    public double latitude() {
        return this._latitude;
    }

    public double longitude() {
        return this._longitude;
    }

    public String toISO6709() {
        return String.format(Locale.ROOT, "%+09.5f%+010.5f", this._latitude, this._longitude);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LatLong)) {
            return false;
        }
        LatLong other = (LatLong)o;
        return Double.compare(other._latitude, this._latitude) == 0 && Double.compare(other._longitude, this._longitude) == 0;
    }

    public int hashCode() {
        return Objects.hash(this._latitude, this._longitude);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%+09.5f%+010.5f", this._latitude, this._longitude);
    }
}

