/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.JSONParser;

public class JSONCompare {
    private JSONCompare() {
    }

    public static JSONCompareResult compareJSON(String expectedStr, String actualStr, JSONCompareMode mode) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        Object actual = JSONParser.parseJSON(actualStr);
        if (expected instanceof JSONObject && actual instanceof JSONObject) {
            return JSONCompare.compareJSON((JSONObject)expected, (JSONObject)actual, mode);
        }
        if (expected instanceof JSONArray && actual instanceof JSONArray) {
            return JSONCompare.compareJSON((JSONArray)expected, (JSONArray)actual, mode);
        }
        if (expected instanceof JSONObject) {
            return new JSONCompareResult().fail("", expected, actual);
        }
        return new JSONCompareResult().fail("", expected, actual);
    }

    public static JSONCompareResult compareJSON(JSONObject expected, JSONObject actual, JSONCompareMode mode) throws JSONException {
        JSONCompareResult result = new JSONCompareResult();
        JSONCompare.compareJSON("", expected, actual, mode, result);
        return result;
    }

    public static JSONCompareResult compareJSON(JSONArray expected, JSONArray actual, JSONCompareMode mode) throws JSONException {
        JSONCompareResult result = new JSONCompareResult();
        JSONCompare.compareJSONArray("", expected, actual, mode, result);
        return result;
    }

    private static void compareJSON(String prefix, JSONObject expected, JSONObject actual, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        Set<String> expectedKeys = JSONCompare.getKeys(expected);
        for (String key : expectedKeys) {
            Object expectedValue = expected.get(key);
            if (actual.has(key)) {
                Object actualValue = actual.get(key);
                JSONCompare.compareValues(JSONCompare.qualify(prefix, key), expectedValue, actualValue, mode, result);
                continue;
            }
            result.missing(prefix, key);
        }
        if (!mode.isExtensible()) {
            Set<String> actualKeys = JSONCompare.getKeys(actual);
            for (String key : actualKeys) {
                if (expected.has(key)) continue;
                result.unexpected(prefix, key);
            }
        }
    }

    private static String qualify(String prefix, String key) {
        return "".equals(prefix) ? key : prefix + "." + key;
    }

    private static void compareValues(String fullKey, Object expectedValue, Object actualValue, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        if (expectedValue.getClass().isAssignableFrom(actualValue.getClass())) {
            if (expectedValue instanceof JSONArray) {
                JSONCompare.compareJSONArray(fullKey, (JSONArray)expectedValue, (JSONArray)actualValue, mode, result);
            } else if (expectedValue instanceof JSONObject) {
                JSONCompare.compareJSON(fullKey, (JSONObject)expectedValue, (JSONObject)actualValue, mode, result);
            } else if (!expectedValue.equals(actualValue)) {
                result.fail(fullKey, expectedValue, actualValue);
            }
        } else {
            result.fail(fullKey, expectedValue, actualValue);
        }
    }

    private static void compareJSONArray(String key, JSONArray expected, JSONArray actual, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        if (expected.length() != actual.length()) {
            result.fail(key + "[]: Expected " + expected.length() + " values but got " + actual.length());
            return;
        }
        if (expected.length() == 0) {
            return;
        }
        if (mode.hasStrictOrder()) {
            for (int i = 0; i < expected.length(); ++i) {
                Object expectedValue = expected.get(i);
                Object actualValue = actual.get(i);
                JSONCompare.compareValues(key + "[" + i + "]", expectedValue, actualValue, mode, result);
            }
        } else if (JSONCompare.allSimpleValues(expected)) {
            Map expectedCount = CollectionUtils.getCardinalityMap(JSONCompare.jsonArrayToList(expected));
            Map actualCount = CollectionUtils.getCardinalityMap(JSONCompare.jsonArrayToList(actual));
            for (Object o : expectedCount.keySet()) {
                if (!actualCount.containsKey(o)) {
                    result.missing(key + "[]", o);
                    continue;
                }
                if (((Integer)actualCount.get(o)).equals(expectedCount.get(o))) continue;
                result.fail(key + "[]: Expected " + expectedCount.get(o) + " occurrence(s) of " + o + " but got " + actualCount.get(o) + " occurrence(s)");
            }
            for (Object o : actualCount.keySet()) {
                if (expectedCount.containsKey(o)) continue;
                result.unexpected(key + "[]", o);
            }
        } else if (JSONCompare.allJSONObjects(expected)) {
            String uniqueKey = JSONCompare.findUniqueKey(expected);
            if (uniqueKey == null || !JSONCompare.isUsableAsUniqueKey(uniqueKey, actual)) {
                JSONCompare.recursivelyCompareJSONArray(key, expected, actual, mode, result);
                return;
            }
            Map<Object, JSONObject> expectedValueMap = JSONCompare.arrayOfJsonObjectToMap(expected, uniqueKey);
            Map<Object, JSONObject> actualValueMap = JSONCompare.arrayOfJsonObjectToMap(actual, uniqueKey);
            for (Object id : expectedValueMap.keySet()) {
                if (!actualValueMap.containsKey(id)) {
                    result.missing(JSONCompare.formatUniqueKey(key, uniqueKey, id), expectedValueMap.get(id));
                    continue;
                }
                JSONObject expectedValue = expectedValueMap.get(id);
                JSONObject actualValue = actualValueMap.get(id);
                JSONCompare.compareValues(JSONCompare.formatUniqueKey(key, uniqueKey, id), expectedValue, actualValue, mode, result);
            }
            for (Object id : actualValueMap.keySet()) {
                if (expectedValueMap.containsKey(id)) continue;
                result.unexpected(JSONCompare.formatUniqueKey(key, uniqueKey, id), actualValueMap.get(id));
            }
        } else {
            if (JSONCompare.allJSONArrays(expected)) {
                JSONCompare.recursivelyCompareJSONArray(key, expected, actual, mode, result);
                return;
            }
            JSONCompare.recursivelyCompareJSONArray(key, expected, actual, mode, result);
            return;
        }
    }

    private static String formatUniqueKey(String key, String uniqueKey, Object value) {
        return key + "[" + uniqueKey + "=" + value + "]";
    }

    private static void recursivelyCompareJSONArray(String key, JSONArray expected, JSONArray actual, JSONCompareMode mode, JSONCompareResult result) throws JSONException {
        HashSet<Integer> matched = new HashSet<Integer>();
        for (int i = 0; i < expected.length(); ++i) {
            Object expectedElement = expected.get(i);
            boolean matchFound = false;
            for (int j = 0; j < actual.length(); ++j) {
                Object actualElement = actual.get(j);
                if (matched.contains(j) || !actualElement.getClass().equals(expectedElement.getClass())) continue;
                if (expectedElement instanceof JSONObject) {
                    if (!JSONCompare.compareJSON((JSONObject)expectedElement, (JSONObject)actualElement, mode).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (expectedElement instanceof JSONArray) {
                    if (!JSONCompare.compareJSON((JSONArray)expectedElement, (JSONArray)actualElement, mode).passed()) continue;
                    matched.add(j);
                    matchFound = true;
                    break;
                }
                if (!expectedElement.equals(actualElement)) continue;
                matched.add(j);
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            result.fail(key + "[" + i + "] Could not find match for element " + expectedElement);
            return;
        }
    }

    private static Map<Object, JSONObject> arrayOfJsonObjectToMap(JSONArray array, String uniqueKey) throws JSONException {
        HashMap<Object, JSONObject> valueMap = new HashMap<Object, JSONObject>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject jsonObject = (JSONObject)array.get(i);
            Object id = jsonObject.get(uniqueKey);
            valueMap.put(id, jsonObject);
        }
        return valueMap;
    }

    private static String findUniqueKey(JSONArray expected) throws JSONException {
        JSONObject o = (JSONObject)expected.get(0);
        for (String candidate : JSONCompare.getKeys(o)) {
            if (!JSONCompare.isUsableAsUniqueKey(candidate, expected)) continue;
            return candidate;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isUsableAsUniqueKey(String candidate, JSONArray array) throws JSONException {
        HashSet<Object> seenValues = new HashSet<Object>();
        for (int i = 0; i < array.length(); ++i) {
            Object item = array.get(i);
            if (!(item instanceof JSONObject)) return false;
            JSONObject o = (JSONObject)item;
            if (!o.has(candidate)) return false;
            Object value = o.get(candidate);
            if (!JSONCompare.isSimpleValue(value) || seenValues.contains(value)) {
                return false;
            }
            seenValues.add(value);
        }
        return true;
    }

    private static List<Object> jsonArrayToList(JSONArray expected) throws JSONException {
        ArrayList<Object> jsonObjects = new ArrayList<Object>(expected.length());
        for (int i = 0; i < expected.length(); ++i) {
            jsonObjects.add(expected.get(i));
        }
        return jsonObjects;
    }

    private static boolean allSimpleValues(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (JSONCompare.isSimpleValue(array.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSimpleValue(Object o) {
        return !(o instanceof JSONObject) && !(o instanceof JSONArray);
    }

    private static boolean allJSONObjects(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (array.get(i) instanceof JSONObject) continue;
            return false;
        }
        return true;
    }

    private static boolean allJSONArrays(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            if (array.get(i) instanceof JSONArray) continue;
            return false;
        }
        return true;
    }

    private static Set<String> getKeys(JSONObject jsonObject) {
        TreeSet<String> keys = new TreeSet<String>();
        Iterator iter = jsonObject.keys();
        while (iter.hasNext()) {
            keys.add((String)iter.next());
        }
        return keys;
    }
}

