package org.hansken.plugin.extraction.test;

/**
 * Exception type to indicate exceptions that are related test input (test files, or plugin).
 * <p>
 * The message of this exception is intended to be shown to the user, and should contain the following:
 * <ul>
 *   <li>a clear description what was wrong</li>
 *   <li>a clear description how the user can address the issue</li>
 *   <li>reference to a section in the documentation for more details</li>
 * </ul>
 */
public class TestFrameworkException extends RuntimeException {
    public TestFrameworkException(final String message) {
        super(message);
    }

    public TestFrameworkException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
