/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.Trace;
import nl.minvenj.nfi.flits.serialize.CustomConversion;
import nl.minvenj.nfi.flits.serialize.CustomOrder;
import nl.minvenj.nfi.flits.serialize.MapUtil;
import nl.minvenj.nfi.flits.serialize.PatternMatch;
import nl.minvenj.nfi.flits.serialize.PlatformIndependentPrettyPrinter;
import nl.minvenj.nfi.flits.serialize.Property;
import nl.minvenj.nfi.flits.util.ExceptionUtil;
import org.apache.commons.lang3.StringUtils;
import org.hansken.plugin.extraction.api.Vector;

public final class TraceToJson {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC);
    private static final DefaultIndenter ARRAY_INDENTER = new DefaultIndenter("  ", "\n");
    private static final CustomOrder DEFAULT_ORDER = CustomOrder.create(any -> true, String::compareTo);
    private static final Map<String, Integer> TIMESTAMP_FIELD_ORDER = Map.ofEntries(Map.entry("format", 0), Map.entry("valid", 1), Map.entry("timeZone", 2), Map.entry("resolution", 3), Map.entry("year", 4), Map.entry("month", 5), Map.entry("day", 6), Map.entry("hour", 7), Map.entry("minute", 8), Map.entry("second", 9), Map.entry("millisecond", 10), Map.entry("microsecond", 11), Map.entry("nanosecond", 12), Map.entry("invalidUnits", 13));
    private static final CustomOrder DEFAULT_TIMESTAMP_ORDER = CustomOrder.create(trace -> trace.types().contains("timestamp"), Comparator.comparingInt(property -> TIMESTAMP_FIELD_ORDER.getOrDefault(TraceToJson.timestampProperty(property), Integer.MAX_VALUE)));
    private final List<BiPredicate<String, Object>> _exclusionFilters;
    private final List<CustomConversion> _customConversions;
    private final List<CustomOrder> _customOrders;

    private TraceToJson(List<BiPredicate<String, Object>> exclusionFilters, List<CustomConversion> customConversions, List<CustomOrder> customOrders) {
        this._exclusionFilters = TraceToJson.toImmutableList(ArgChecks.argNotNull("exclusionFilters", exclusionFilters));
        this._customConversions = TraceToJson.toImmutableList(ArgChecks.argNotNull("customConversions", customConversions));
        this._customOrders = TraceToJson.toImmutableList(ArgChecks.argNotNull("customOrders", customOrders));
    }

    public static TraceToJson create() {
        return new TraceToJson(Collections.singletonList((property, value) -> false), Collections.emptyList(), Collections.singletonList(DEFAULT_TIMESTAMP_ORDER));
    }

    public TraceToJson exclude(BiPredicate<String, Object> exclusionFilter) {
        ArgChecks.argNotNull("exclusionFilter", exclusionFilter);
        ArrayList<BiPredicate<String, Object>> exclusionFilters = new ArrayList<BiPredicate<String, Object>>(this._exclusionFilters);
        exclusionFilters.add(exclusionFilter);
        return new TraceToJson(exclusionFilters, this._customConversions, this._customOrders);
    }

    public <T> TraceToJson addCustomConversion(Class<T> type, Function<? super T, String> conversion) {
        ArgChecks.argNotNull("type", type);
        ArgChecks.argNotNull("conversion", conversion);
        ArrayList<CustomConversion> customConversions = new ArrayList<CustomConversion>(this._customConversions);
        customConversions.add(CustomConversion.create(type, conversion));
        return new TraceToJson(this._exclusionFilters, customConversions, this._customOrders);
    }

    public TraceToJson addCustomOrder(Predicate<? super Trace> predicate, Comparator<? super String> comparator) {
        ArgChecks.argNotNull("predicate", predicate);
        ArgChecks.argNotNull("comparator", comparator);
        LinkedList<CustomOrder> customOrders = new LinkedList<CustomOrder>(this._customOrders);
        customOrders.add(0, CustomOrder.create(predicate, comparator));
        return new TraceToJson(this._exclusionFilters, this._customConversions, customOrders);
    }

    public String toJsonString(List<Trace> traces) {
        ArgChecks.argNotNull("traces", traces);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.writeToStream(traces, output);
        return output.toString(StandardCharsets.UTF_8);
    }

    public void writeToFile(List<Trace> traces, File file) {
        ArgChecks.argNotNull("traces", traces);
        ArgChecks.argNotNull("file", file);
        ExceptionUtil.uncheckedIO(() -> {
            file.createNewFile();
            this.writeToStream(traces, new FileOutputStream(file));
        });
    }

    public void writeToPath(List<Trace> traces, Path path) {
        ArgChecks.argNotNull("traces", traces);
        ArgChecks.argNotNull("path", path);
        ExceptionUtil.uncheckedIO(() -> {
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            this.writeToFile(traces, path.toFile());
        });
    }

    public void writeToStream(List<Trace> traces, OutputStream outputStream) {
        ArgChecks.argNotNull("traces", traces);
        ArgChecks.argNotNull("outputStream", outputStream);
        PlatformIndependentPrettyPrinter prettyPrinter = new PlatformIndependentPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)ARRAY_INDENTER);
        JsonFactory factory = new JsonFactory();
        JsonGenerator generator = ExceptionUtil.uncheckedIO(() -> factory.createGenerator(outputStream, JsonEncoding.UTF8));
        generator.setPrettyPrinter((PrettyPrinter)prettyPrinter);
        this.writeToGenerator(traces, generator);
    }

    public void writeToGenerator(List<Trace> traces, JsonGenerator generator) {
        ArgChecks.argNotNull("traces", traces);
        ArgChecks.argNotEmpty("traces", traces);
        ArgChecks.argNotNull("generator", generator);
        if (traces.size() != 1) {
            throw new IllegalArgumentException("Multiple traces are currently not supported");
        }
        this.writeToGenerator(traces.get(0), generator);
    }

    private void writeToGenerator(Trace trace, JsonGenerator generator) {
        ArgChecks.argNotNull("trace", trace);
        ArgChecks.argNotNull("generator", generator);
        ExceptionUtil.uncheckedIO(() -> {
            generator.writeStartObject();
            this.writeTypes(trace, generator);
            this.writeChildren(trace, generator);
            this.writeData(trace, generator);
            generator.writeEndObject();
            generator.flush();
        });
    }

    public void writeTypes(Trace trace, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            generator.writeObjectFieldStart("trace");
            generator.writeStringField("id", (String)trace.get("id"));
            generator.writeStringField("name", (String)trace.get("name"));
            generator.writeStringField("path", (String)trace.get("path"));
            Map propertiesByType = trace.properties().stream().filter(Predicate.not("id"::equals)).filter(Predicate.not("name"::equals)).filter(Predicate.not("path"::equals)).filter(Predicate.not("image"::equals)).filter(Predicate.not(property -> property.startsWith("$"))).map(Property::parse).collect(Collectors.groupingBy(Property::type, TreeMap::new, Collectors.mapping(Function.identity(), Collectors.toSet())));
            trace.types().stream().sorted().forEachOrdered(type -> ExceptionUtil.uncheckedIO(() -> {
                generator.writeObjectFieldStart(type);
                this.writeProperties(trace, propertiesByType.getOrDefault(type, Collections.emptySet()), generator);
                generator.writeEndObject();
            }));
            this.writePreviews(trace, generator);
            generator.writeEndObject();
        });
    }

    public void writeProperties(Trace trace, Set<Property> properties, JsonGenerator generator) {
        Map<Property, Object> mapProperties = properties.stream().filter(property -> property.name().contains(".")).collect(Collectors.toMap(property -> Property.parse(MapUtil.getMapNamePostfix(property)), property -> trace.get(property.fullName())));
        Map<String, Object> mapPropertyValues = MapUtil.mapMap(mapProperties, 0);
        Set newMapProperties = mapPropertyValues.keySet().stream().map(Property::parse).collect(Collectors.toSet());
        Set nonMapProperties = properties.stream().filter(property -> !property.name().contains(".")).collect(Collectors.toUnmodifiableSet());
        Map<String, Object> nonMapPropertyValues = nonMapProperties.stream().collect(Collectors.toMap(Property::fullName, property -> trace.get(property.fullName())));
        HashMap<String, Object> allPropertyValues = new HashMap<String, Object>();
        allPropertyValues.putAll(mapPropertyValues);
        allPropertyValues.putAll(nonMapPropertyValues);
        HashSet<Property> allProperties = new HashSet<Property>();
        allProperties.addAll(newMapProperties);
        allProperties.addAll(nonMapProperties);
        this._customOrders.stream().filter(customOrder -> customOrder.triggersOn(trace)).findFirst().orElse(DEFAULT_ORDER).order(allProperties).forEachOrdered(property -> this.write((Map<String, Object>)allPropertyValues, (Property)property, generator));
    }

    private void writeChildren(Trace trace, JsonGenerator generator) throws IOException {
        Iterator iterator = trace.children().iterator();
        if (iterator.hasNext()) {
            generator.writeArrayFieldStart("children");
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).sorted(Comparator.comparingInt(child -> child.types().size()).thenComparingInt(child -> child.types().hashCode())).forEachOrdered(child -> this.writeToGenerator((Trace)child, generator));
            generator.writeEndArray();
        }
    }

    private void writeData(Trace trace, JsonGenerator generator) {
        Map transformationPropertiesByType = trace.properties().stream().filter(property -> property.startsWith("#")).map(Property::parse).collect(Collectors.groupingBy(Property::type, TreeMap::new, Collectors.mapping(Function.identity(), Collectors.toSet())));
        if (!transformationPropertiesByType.isEmpty()) {
            ExceptionUtil.uncheckedIO(() -> {
                generator.writeObjectFieldStart("data");
                transformationPropertiesByType.keySet().stream().sorted().map(type -> type.substring(1)).forEachOrdered(type -> ExceptionUtil.uncheckedIO(() -> {
                    generator.writeObjectFieldStart(type);
                    this.writeProperties(trace, transformationPropertiesByType.getOrDefault("#" + type, Collections.emptySet()), generator);
                    generator.writeEndObject();
                }));
                generator.writeEndObject();
            });
        }
    }

    public void writePreviews(Trace trace, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            List previewProperties = trace.properties().stream().filter(property -> property.startsWith("preview.")).sorted().collect(Collectors.toList());
            if (previewProperties.size() > 1) {
                generator.writeObjectFieldStart("preview");
            }
            for (String previewProperty : previewProperties) {
                this.write(TraceToJson.getPreviewPropertyName(previewProperties.size(), previewProperty), trace.get(previewProperty), generator);
            }
            if (previewProperties.size() > 1) {
                generator.writeEndObject();
            }
        });
    }

    private static String getPreviewPropertyName(int numberOfPreviews, String previewProperty) {
        return numberOfPreviews > 1 ? StringUtils.substringAfter((String)previewProperty, (String)"preview.") : previewProperty;
    }

    private void write(Map<String, Object> tracePropertyValues, Property property, JsonGenerator generator) {
        Object value = tracePropertyValues.get(property.fullName());
        this.write(property.name(), value, generator);
    }

    private void write(String name, Object value, JsonGenerator generator) {
        for (BiPredicate<String, Object> filter : this._exclusionFilters) {
            if (!filter.test(name, value)) continue;
            return;
        }
        PatternMatch.when(value).matchesAny(this._customConversions, string -> TraceToJson.writeString(name, string, generator)).matches(Boolean.class, boolVal -> TraceToJson.writeBoolean(name, boolVal, generator)).matches(Date.class, date -> TraceToJson.writeDate(name, date, generator)).matches(Double.class, doubleVal -> TraceToJson.writeDouble(name, doubleVal, generator)).matches(Integer.class, intVal -> TraceToJson.writeInteger(name, intVal, generator)).matches(Long.class, longVal -> TraceToJson.writeLong(name, longVal, generator)).matches(Map.class, map -> this.writeMap(name, (Map<?, ?>)map, generator)).matches(Stream.class, stream -> this.writeStream(name, (Stream<?>)stream, generator)).matches(String.class, string -> TraceToJson.writeString(name, string, generator)).matches(Supplier.class, supplier -> this.writeSupplier(name, (Supplier<?>)supplier, generator)).matches(Trace.class, trace -> this.writeTrace(name, (Trace)trace, generator)).matches(Vector.class, vector -> TraceToJson.writeVector(name, vector, generator)).matches(Collection.class, collection -> this.writeStream(name, collection.stream(), generator)).elseThrow(unknownProperty -> new IllegalArgumentException("unhandled type of property [" + name + "]: " + unknownProperty.getClass()));
    }

    private static void writeBoolean(String name, Boolean value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeBooleanField(name, value.booleanValue()));
    }

    private static void writeDate(String name, Date value, JsonGenerator generator) {
        Instant instant = value.toInstant();
        String dateTimeString = DATE_TIME_FORMATTER.format(instant);
        ExceptionUtil.uncheckedIO(() -> generator.writeStringField(name, dateTimeString));
    }

    private static void writeDouble(String name, Double value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeNumberField(name, value.doubleValue()));
    }

    private static void writeInteger(String name, Integer value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeNumberField(name, value.intValue()));
    }

    private static void writeLong(String name, Long value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeNumberField(name, value.longValue()));
    }

    private void writeMap(String name, Map<?, ?> value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            generator.writeObjectFieldStart(name);
            new TreeMap<Object, Object>(value).forEach((k, v) -> this.write((String)k, v, generator));
            generator.writeEndObject();
        });
    }

    private void writeStream(String name, Stream<?> value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            generator.writeArrayFieldStart(name);
            value.forEachOrdered(element -> this.writeArrayElement(element, generator));
            generator.writeEndArray();
        });
    }

    private static void writeString(String name, String value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeStringField(name, value));
    }

    private static void writeVector(String name, Vector value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeStringField(name, value.toBase64()));
    }

    private void writeSupplier(String name, Supplier<?> supplier, JsonGenerator generator) {
        this.write(name, supplier.get(), generator);
    }

    private void writeArrayElement(Object element, JsonGenerator generator) {
        PatternMatch.when(element).matchesAny(this._customConversions, string -> TraceToJson.writeStringEntry(string, generator)).matches(String.class, string -> TraceToJson.writeStringEntry(string, generator)).matches(Integer.class, value -> TraceToJson.writeLongEntry(value.intValue(), generator)).matches(Long.class, longValue -> TraceToJson.writeLongEntry(longValue, generator)).matches(Double.class, value -> TraceToJson.writeDoubleEntry(value, generator)).elseThrow(unknownProperty -> new IllegalArgumentException("unhandled type of stream element: " + element.getClass()));
    }

    private void writeTrace(String name, Trace trace, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            generator.writeFieldName(name);
            this.writeToGenerator(trace, generator);
        });
    }

    private static void writeStringEntry(String value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeString(value));
    }

    private static void writeLongEntry(long value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeNumber(value));
    }

    private static void writeDoubleEntry(double value, JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> generator.writeNumber(value));
    }

    private static <T> List<T> toImmutableList(List<T> list) {
        return List.copyOf(list);
    }

    private static String timestampProperty(String property) {
        return property.substring(property.lastIndexOf(46) + 1);
    }
}

