/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hansken.ep.shade.com.google.common.collect.Sets;
import org.hansken.ep.shade.com.google.protobuf.Any;
import org.hansken.ep.shade.com.google.protobuf.Empty;
import org.hansken.ep.shade.io.grpc.ConnectivityState;
import org.hansken.ep.shade.io.grpc.ManagedChannel;
import org.hansken.ep.shade.io.grpc.ManagedChannelBuilder;
import org.hansken.ep.shade.io.grpc.Metadata;
import org.hansken.ep.shade.io.grpc.StatusRuntimeException;
import org.hansken.ep.shade.io.grpc.internal.GrpcUtil;
import org.hansken.ep.shade.io.grpc.stub.MetadataUtils;
import org.hansken.ep.shade.io.grpc.stub.StreamObserver;
import org.hansken.extraction.plugin.grpc.ExtractionPluginServiceGrpc;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.extraction.plugin.grpc.RpcTransformerArgument;
import org.hansken.extraction.plugin.grpc.RpcTransformerRequest;
import org.hansken.extraction.plugin.grpc.RpcTransformerResponse;
import org.hansken.plugin.extraction.api.LatLong;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.api.TransformerArgument;
import org.hansken.plugin.extraction.api.TransformerLabel;
import org.hansken.plugin.extraction.api.Vector;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginDataReader;
import org.hansken.plugin.extraction.runtime.grpc.client.ExtractionPluginGrpcAdapter;
import org.hansken.plugin.extraction.runtime.grpc.client.ProtocolHandler;
import org.hansken.plugin.extraction.runtime.grpc.client.ReplyStream;
import org.hansken.plugin.extraction.runtime.grpc.client.RetryPolicy;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.runtime.grpc.client.api.RemoteExtractionPlugin;
import org.hansken.plugin.extraction.runtime.grpc.common.Pack;
import org.hansken.plugin.extraction.runtime.grpc.common.Unpack;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.hansken.plugin.extraction.runtime.json.PluginModule;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractionPluginClient
implements RemoteExtractionPlugin,
AutoCloseable {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new PluginModule()).registerModule((Module)new JavaTimeModule());
    private static final Logger LOG = LoggerFactory.getLogger(ExtractionPluginClient.class);
    private static final Empty EMPTY = Empty.getDefaultInstance();
    private static final int MAX_MESSAGE_SIZE = 0x4000000;
    private static final Map<String, Class<?>> SUPPORTED_TRANSFORMER_TYPES = Map.of("boolean", Boolean.class, "binary", byte[].class, "long", Long.class, "double", Double.class, "string", String.class, "vector", Vector.class, "latLong", LatLong.class, "date", ZonedDateTime.class, "list", List.class, "map", Map.class);
    private final ManagedChannel _channel;
    private final ExtractionPluginServiceGrpc.ExtractionPluginServiceBlockingStub _blockingPluginStub;
    private final ExtractionPluginServiceGrpc.ExtractionPluginServiceStub _asyncPluginStub;
    private final String _target;
    private RpcPluginInfo _pluginInfo;

    public ExtractionPluginClient(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    public ExtractionPluginClient(String host, int port, RetryPolicy retryPolicy) {
        this(GrpcUtil.authorityFromHostAndPort(host, port), retryPolicy);
    }

    public ExtractionPluginClient(String target) {
        this(target, null);
    }

    public ExtractionPluginClient(String target, RetryPolicy retryPolicy) {
        this(target, retryPolicy, "");
    }

    public ExtractionPluginClient(String target, RetryPolicy retryPolicy, String pluginId) {
        ArgChecks.argNotNull((String)"pluginId", (Object)pluginId);
        this._target = (String)ArgChecks.argNotNull((String)"target", (Object)target);
        Object builder = ((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(target).usePlaintext()).maxInboundMessageSize(0x4000000);
        this._channel = retryPolicy == null ? ((ManagedChannelBuilder)builder).build() : ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)builder).defaultServiceConfig(retryPolicy.toMethodConfigMap())).enableRetry()).maxRetryAttempts(retryPolicy.maxAttempts())).build();
        Metadata header = new Metadata();
        header.put(Metadata.Key.of("pluginId", Metadata.ASCII_STRING_MARSHALLER), pluginId);
        this._blockingPluginStub = (ExtractionPluginServiceGrpc.ExtractionPluginServiceBlockingStub)ExtractionPluginServiceGrpc.newBlockingStub(this._channel).withInterceptors(MetadataUtils.newAttachHeadersInterceptor(header));
        this._asyncPluginStub = (ExtractionPluginServiceGrpc.ExtractionPluginServiceStub)ExtractionPluginServiceGrpc.newStub(this._channel).withInterceptors(MetadataUtils.newAttachHeadersInterceptor(header));
    }

    @Override
    public boolean isCompatible() {
        String remotePluginVersion = this.getPluginApiVersion();
        return VersionUtil.isCompatible((String)remotePluginVersion);
    }

    public String getPluginApiVersion() {
        return Unpack.pluginApiVersion((RpcPluginInfo)this.getRpcPluginInfo());
    }

    public PluginInfo pluginInfo() {
        return Unpack.pluginInfo((RpcPluginInfo)this.getRpcPluginInfo());
    }

    private RpcPluginInfo getRpcPluginInfo() {
        if (this._pluginInfo == null) {
            this._pluginInfo = this._blockingPluginStub.pluginInfo(EMPTY);
        }
        return this._pluginInfo;
    }

    final void process(ClientTrace trace, ClientDataContext dataContext, TraceSearcher traceSearcher, ReplyStream replyStream) {
        ProtocolHandler protocolHandler = this.handler(trace, dataContext, traceSearcher, replyStream);
        StreamObserver<Any> responseSender = this._asyncPluginStub.process(protocolHandler);
        replyStream.init(responseSender);
        protocolHandler.start(trace, dataContext);
        protocolHandler.await();
    }

    @Override
    public void process(ClientTrace trace, ClientDataContext dataContext) throws IOException {
        this.withUnwrappedExceptions(() -> this.process(trace, dataContext, null, new ReplyStream()));
    }

    @Override
    public void processDeferred(ClientTrace trace, ClientDataContext dataContext, TraceSearcher searcher) throws IOException {
        this.withUnwrappedExceptions(() -> this.process(trace, dataContext, searcher, new ReplyStream()));
    }

    public void validateTransformerRequest(TransformerLabel label, Map<String, TransformerArgument> arguments) throws IllegalArgumentException {
        if (!label.getParameters().keySet().equals(arguments.keySet())) {
            throw new IllegalArgumentException("The provided arguments do not match the parameters in the TransformerLabel. Required: " + label.getParameters().keySet() + ", Provided: " + arguments.keySet());
        }
        for (Map.Entry parameter : label.getParameters().entrySet()) {
            TransformerArgument argument = arguments.get(parameter.getKey());
            if (!SUPPORTED_TRANSFORMER_TYPES.containsKey(parameter.getValue())) {
                throw new IllegalStateException(String.format(Locale.ROOT, "TransformerLabel for %s contains an illegal value: %s", label.getMethodName(), parameter.getValue()));
            }
            Class<?> expectedType = SUPPORTED_TRANSFORMER_TYPES.get(parameter.getValue());
            if (expectedType.isInstance(argument.getArgument())) continue;
            throw new IllegalStateException(String.format(Locale.ROOT, "Provided argument is not of type provided in Transformer. " + String.format(Locale.ROOT, "Transformer Type: %s, Provided: %s, Expected: %s", parameter.getValue(), argument.getArgument(), expectedType), new Object[0]));
        }
    }

    @Override
    public TransformerArgument transform(TransformerLabel label, Map<String, String> stringMap) {
        Map<String, TransformerArgument> arguments = this.deserializeJsonArguments(label, stringMap);
        this.validateTransformerRequest(label, arguments);
        RpcTransformerRequest request = Pack.transformerRequest((TransformerLabel)label, (Map)Pack.transformerArgumentMap(arguments));
        RpcTransformerResponse response = this.invokeTransformer(request);
        return new TransformerArgument(Unpack.transformerArgument((RpcTransformerArgument)Unpack.transformerResponse((RpcTransformerResponse)response)));
    }

    public Map<String, TransformerArgument> deserializeJsonArguments(TransformerLabel label, Map<String, String> arguments) {
        HashMap<String, TransformerArgument> map = new HashMap<String, TransformerArgument>();
        for (String key : Sets.intersection(arguments.keySet(), label.getParameters().keySet())) {
            String type = (String)label.getParameters().get(key);
            String value = arguments.get(key);
            map.put(key, new TransformerArgument(ExtractionPluginClient.createTransformerArgument(type, value)));
        }
        return map;
    }

    public static Object createTransformerArgument(String type, String value) {
        if (!value.isBlank()) {
            try {
                return ExtractionPluginClient.jsonConverter(type, value);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Json input was empty or null.");
    }

    private static Object jsonConverter(String type, String jsonString) throws JsonProcessingException {
        switch (type) {
            case "binary": {
                return MAPPER.readValue(jsonString, byte[].class);
            }
            case "boolean": {
                return MAPPER.readValue(jsonString, Boolean.class);
            }
            case "date": {
                ZonedDateTime date = (ZonedDateTime)MAPPER.readValue(jsonString, ZonedDateTime.class);
                return Instant.ofEpochSecond(date.toEpochSecond()).atZone(ZoneId.of("UTC"));
            }
            case "double": {
                return MAPPER.readValue(jsonString, Double.class);
            }
            case "latLong": {
                return MAPPER.readValue(jsonString, LatLong.class);
            }
            case "long": {
                return MAPPER.readValue(jsonString, Long.class);
            }
            case "string": {
                return MAPPER.readValue(jsonString, String.class);
            }
            case "vector": {
                return MAPPER.readValue(jsonString, Vector.class);
            }
            case "list": {
                return MAPPER.readValue(jsonString, List.class);
            }
            case "map": {
                return MAPPER.readValue(jsonString, Map.class);
            }
        }
        throw new IllegalArgumentException("Unsupported argument type");
    }

    protected RpcTransformerResponse invokeTransformer(RpcTransformerRequest request) {
        return this._blockingPluginStub.transform(request);
    }

    private void withUnwrappedExceptions(Runnable runnable) throws IOException {
        try {
            runnable.run();
        }
        catch (StatusRuntimeException e) {
            LOG.debug("Got a gRPC StatusRuntimeException (status: {}), logging this here, since the unwrapped exception is rethrown from here", (Object)e.getStatus(), (Object)e);
            throw this.unwrap(e);
        }
    }

    public String getTarget() {
        return this._target;
    }

    protected ProtocolHandler handler(ClientTrace trace, ClientDataContext dataContext, TraceSearcher searcher, ReplyStream stream) {
        return new ProtocolHandler(stream, this.adapter(trace, dataContext, searcher));
    }

    ConnectivityState getState() {
        return this._channel.getState(true);
    }

    protected ExtractionPluginGrpcAdapter adapter(ClientTrace trace, ClientDataContext dataContext, TraceSearcher searcher) {
        return new ExtractionPluginGrpcAdapter(trace, dataContext, new ExtractionPluginDataReader(dataContext), searcher);
    }

    @Override
    public void close() throws InterruptedException {
        this._channel.shutdownNow().awaitTermination(5L, TimeUnit.SECONDS);
    }

    private RuntimeException unwrap(StatusRuntimeException e) throws IOException {
        if (e.getCause() == null) {
            throw e;
        }
        if (e.getCause() instanceof StatusRuntimeException) {
            return this.unwrap((StatusRuntimeException)e.getCause());
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        return new IllegalStateException(e.getCause());
    }
}

