/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.api.result;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.api.FlitsResult;
import nl.minvenj.nfi.flits.api.FlitsResultGenerator;
import nl.minvenj.nfi.flits.api.FlitsResultValidator;

public final class EmptyResult
implements FlitsResult {
    private static final String NO_RESULTS = "Produced no results";
    private final String _factoryName;
    private final String _description;

    public EmptyResult() {
        this(NO_RESULTS);
    }

    public EmptyResult(String description) {
        this._description = ArgChecks.argNotNull("description", description);
        this._factoryName = null;
    }

    public EmptyResult(String description, String factoryName) {
        this._description = ArgChecks.argNotNull("description", description);
        this._factoryName = ArgChecks.argNotNull("factoryName", factoryName);
    }

    public static EmptyResult forFactory(String factoryName) {
        return new EmptyResult(NO_RESULTS, factoryName);
    }

    @Override
    public void validate(FlitsResultValidator validator, Path inputPath) throws IOException {
        validator.validate(this, inputPath);
    }

    @Override
    public void generate(FlitsResultGenerator generator, Path outputPath) throws IOException {
        generator.generate(this, outputPath);
    }

    public Optional<String> factoryName() {
        return Optional.ofNullable(this._factoryName);
    }

    public String description() {
        return this._description;
    }
}

