/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hansken.extraction.plugin.grpc.RpcAuthor;
import org.hansken.extraction.plugin.grpc.RpcBoolean;
import org.hansken.extraction.plugin.grpc.RpcBytes;
import org.hansken.extraction.plugin.grpc.RpcDouble;
import org.hansken.extraction.plugin.grpc.RpcDoubleList;
import org.hansken.extraction.plugin.grpc.RpcEmptyList;
import org.hansken.extraction.plugin.grpc.RpcEmptyMap;
import org.hansken.extraction.plugin.grpc.RpcFinish;
import org.hansken.extraction.plugin.grpc.RpcInteger;
import org.hansken.extraction.plugin.grpc.RpcIsoDateString;
import org.hansken.extraction.plugin.grpc.RpcLatLong;
import org.hansken.extraction.plugin.grpc.RpcList;
import org.hansken.extraction.plugin.grpc.RpcLong;
import org.hansken.extraction.plugin.grpc.RpcLongList;
import org.hansken.extraction.plugin.grpc.RpcMap;
import org.hansken.extraction.plugin.grpc.RpcMaturity;
import org.hansken.extraction.plugin.grpc.RpcNull;
import org.hansken.extraction.plugin.grpc.RpcPluginIdentifier;
import org.hansken.extraction.plugin.grpc.RpcPluginInfo;
import org.hansken.extraction.plugin.grpc.RpcPluginResources;
import org.hansken.extraction.plugin.grpc.RpcPluginType;
import org.hansken.extraction.plugin.grpc.RpcRangedTransformation;
import org.hansken.extraction.plugin.grpc.RpcSearchScope;
import org.hansken.extraction.plugin.grpc.RpcStart;
import org.hansken.extraction.plugin.grpc.RpcString;
import org.hansken.extraction.plugin.grpc.RpcStringList;
import org.hansken.extraction.plugin.grpc.RpcStringMap;
import org.hansken.extraction.plugin.grpc.RpcTracelet;
import org.hansken.extraction.plugin.grpc.RpcTransformation;
import org.hansken.extraction.plugin.grpc.RpcTransformer;
import org.hansken.extraction.plugin.grpc.RpcTransformerArgument;
import org.hansken.extraction.plugin.grpc.RpcTransformerResponse;
import org.hansken.extraction.plugin.grpc.RpcUnixTime;
import org.hansken.extraction.plugin.grpc.RpcVector;
import org.hansken.extraction.plugin.grpc.RpcZonedDateTime;
import org.hansken.plugin.extraction.api.Author;
import org.hansken.plugin.extraction.api.LatLong;
import org.hansken.plugin.extraction.api.MaturityLevel;
import org.hansken.plugin.extraction.api.PluginId;
import org.hansken.plugin.extraction.api.PluginInfo;
import org.hansken.plugin.extraction.api.PluginResources;
import org.hansken.plugin.extraction.api.PluginType;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.TraceSearcher;
import org.hansken.plugin.extraction.api.TransformerLabel;
import org.hansken.plugin.extraction.api.Vector;
import org.hansken.plugin.extraction.api.transformations.DataRange;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.api.transformations.RangedDataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.common.Version;
import org.hansken.plugin.extraction.runtime.grpc.common.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Unpack {
    private static final Logger LOG = LoggerFactory.getLogger(Unpack.class);
    private static final Unpacker PRIMITIVE_UNPACKER = Unpacker.create().register(RpcNull.class, any -> null).register(RpcBytes.class, any -> any.getValue().toByteArray()).register(RpcBoolean.class, RpcBoolean::getValue).register(RpcInteger.class, RpcInteger::getValue).register(RpcLong.class, RpcLong::getValue).register(RpcDouble.class, RpcDouble::getValue).register(RpcString.class, RpcString::getValue).register(RpcUnixTime.class, any -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(any.getValue()), ZoneOffset.UTC)).register(RpcVector.class, Unpack::unpackVector).register(RpcEmptyList.class, any -> Collections.emptyList()).register(RpcEmptyMap.class, any -> Collections.emptyMap()).register(RpcStringList.class, RpcStringList::getValuesList).register(RpcStringMap.class, RpcStringMap::getEntriesMap).register(RpcMap.class, Unpack::getGetEntriesMap).register(RpcLongList.class, RpcLongList::getValuesList).register(RpcDoubleList.class, RpcDoubleList::getValuesList).register(RpcLatLong.class, any -> LatLong.of((double)any.getLatitude(), (double)any.getLongitude())).register(RpcZonedDateTime.class, any -> {
        ZoneOffset offset = ZoneOffset.of(any.getZoneOffset());
        ZoneId id = ZoneId.of(any.getZoneId());
        return ZonedDateTime.ofInstant(LocalDateTime.ofEpochSecond(any.getEpochSecond(), any.getNanoOfSecond(), offset), offset, id);
    }).register(RpcIsoDateString.class, any -> ZonedDateTime.parse(any.getValue(), DateTimeFormatter.ISO_ZONED_DATE_TIME));

    private Unpack() {
    }

    private static Vector unpackVector(RpcVector vector) {
        return Vector.asVector((byte[])vector.getValue().toByteArray());
    }

    private static Map<String, Object> getGetEntriesMap(RpcMap rpcMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        rpcMap.getEntriesMap().forEach((key, value) -> map.put((String)key, Unpack.primitive(value)));
        return map;
    }

    public static RpcStart start(Any any) {
        return Unpack.any(any, RpcStart.class);
    }

    public static RpcFinish finish(Any any) {
        return Unpack.any(any, RpcFinish.class);
    }

    public static <T extends Message> T any(Any any, Class<T> messageType) {
        try {
            return (T)any.unpack(messageType);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("unhandled type of message: " + any.getTypeUrl() + ", expected " + messageType.getCanonicalName());
        }
    }

    public static Object primitive(Any any) {
        return PRIMITIVE_UNPACKER.unpack(any);
    }

    public static byte[] bytes(Any any) {
        return Unpack.any(any, RpcBytes.class).getValue().toByteArray();
    }

    public static PluginInfo pluginInfo(RpcPluginInfo rpcPluginInfo) {
        PluginInfo.Builder builder = PluginInfo.builderFor((PluginType)Unpack.pluginType(rpcPluginInfo.getType())).pluginVersion(rpcPluginInfo.getVersion()).description(rpcPluginInfo.getDescription()).author(Unpack.author(rpcPluginInfo.getAuthor())).maturityLevel(Unpack.maturityLevel(rpcPluginInfo.getMaturity())).hqlMatcher(rpcPluginInfo.getMatcher()).webpageUrl(rpcPluginInfo.getWebpageUrl()).deferredIterations(rpcPluginInfo.getDeferredIterations()).resources(Unpack.pluginResources(rpcPluginInfo.getResources()));
        if (Unpack.isVersionOlderThan040(rpcPluginInfo)) {
            builder.name(rpcPluginInfo.getName());
            LOG.debug("No plugin id present. Incoming message was created by SDK version " + rpcPluginInfo.getApiVersion());
        } else {
            builder.id(Unpack.pluginId(rpcPluginInfo.getId())).license(rpcPluginInfo.getLicense());
        }
        if (rpcPluginInfo.getTransformersList() != null && !rpcPluginInfo.getTransformersList().isEmpty()) {
            builder.transformer(Unpack.transformers(rpcPluginInfo.getTransformersList()));
        }
        return builder.build();
    }

    public static PluginId pluginId(RpcPluginIdentifier rpcPluginIdentifier) {
        return new PluginId(rpcPluginIdentifier.getDomain(), rpcPluginIdentifier.getCategory(), rpcPluginIdentifier.getName());
    }

    public static List<TransformerLabel> transformers(List<RpcTransformer> transformers) {
        return transformers.stream().map(t -> new TransformerLabel(t.getMethodName(), t.getParametersMap(), t.getReturnType())).collect(Collectors.toList());
    }

    public static String pluginApiVersion(RpcPluginInfo rpcPluginInfo) {
        return rpcPluginInfo.getApiVersion();
    }

    public static Trace.Tracelet tracelet(RpcTracelet rpcTracelet) {
        return new Trace.Tracelet(rpcTracelet.getName(), Unpack.getTraceletProperties(rpcTracelet));
    }

    private static List<Trace.TraceletProperty> getTraceletProperties(RpcTracelet property) {
        ArrayList<Trace.TraceletProperty> traceletPropertiesValue = new ArrayList<Trace.TraceletProperty>();
        property.getPropertiesList().forEach(traceletProperty -> traceletPropertiesValue.add(new Trace.TraceletProperty(traceletProperty.getName(), Unpack.primitive(traceletProperty.getValue()))));
        return traceletPropertiesValue;
    }

    public static Author author(RpcAuthor author) {
        return Author.builder().name(author.getName()).email(author.getEmail()).organisation(author.getOrganisation()).build();
    }

    public static MaturityLevel maturityLevel(RpcMaturity maturity) {
        int number = maturity.getNumber();
        if (number > MaturityLevel.values().length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "maturity level %s has a too large number: %d", maturity, number));
        }
        return MaturityLevel.values()[number];
    }

    public static RpcTransformerArgument transformerResponse(RpcTransformerResponse response) {
        return response.getResponse();
    }

    public static Map<String, Object> genericMap(RpcMap map) {
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        for (Map.Entry entry : map.getEntriesMap().entrySet()) {
            try {
                String key = (String)entry.getKey();
                Any value = (Any)entry.getValue();
                if (value.is(RpcList.class)) {
                    convertedMap.put(key, Unpack.genericList((RpcList)value.unpack(RpcList.class)));
                    continue;
                }
                if (((Any)entry.getValue()).is(RpcMap.class)) {
                    convertedMap.put(key, Unpack.genericMap((RpcMap)value.unpack(RpcMap.class)));
                    continue;
                }
                convertedMap.put(key, PRIMITIVE_UNPACKER.unpack(value));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Failed to unpack Any value", e);
            }
        }
        return convertedMap;
    }

    public static List<Object> genericList(RpcList list) {
        ArrayList<Object> convertedList = new ArrayList<Object>();
        for (Any value : list.getValuesList()) {
            try {
                if (value.is(RpcList.class)) {
                    convertedList.add(Unpack.genericList((RpcList)value.unpack(RpcList.class)));
                    continue;
                }
                if (value.is(RpcMap.class)) {
                    convertedList.add(Unpack.genericMap((RpcMap)value.unpack(RpcMap.class)));
                    continue;
                }
                convertedList.add(PRIMITIVE_UNPACKER.unpack(value));
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("Failed to unpack Any value", e);
            }
        }
        return convertedList;
    }

    public static Object transformerArgument(RpcTransformerArgument response) {
        return switch (response.getTypeCase()) {
            case RpcTransformerArgument.TypeCase.BOOLEAN -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getBoolean()));
            case RpcTransformerArgument.TypeCase.BYTES -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getBytes()));
            case RpcTransformerArgument.TypeCase.INTEGER -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getInteger()));
            case RpcTransformerArgument.TypeCase.REAL -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getReal()));
            case RpcTransformerArgument.TypeCase.STRING -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getString()));
            case RpcTransformerArgument.TypeCase.VECTOR -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getVector()));
            case RpcTransformerArgument.TypeCase.LATLONG -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getLatLong()));
            case RpcTransformerArgument.TypeCase.DATETIME -> PRIMITIVE_UNPACKER.unpack(Any.pack((Message)response.getDatetime()));
            case RpcTransformerArgument.TypeCase.LIST -> Unpack.genericList(response.getList());
            case RpcTransformerArgument.TypeCase.MAP -> Unpack.genericMap(response.getMap());
            case RpcTransformerArgument.TypeCase.TYPE_NOT_SET -> throw new IllegalArgumentException("Type not set in RpcTransformerArgument");
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(response.getTypeCase()));
        };
    }

    public static PluginType pluginType(RpcPluginType type) {
        int number = type.getNumber();
        if (number > PluginType.values().length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "plugin type %s has a too large number: %d", type, number));
        }
        return PluginType.values()[number];
    }

    public static PluginResources pluginResources(RpcPluginResources rpcPluginResources) {
        PluginResources.Builder builder = PluginResources.builder();
        Optional.of(Float.valueOf(rpcPluginResources.getMaxCpu())).ifPresent(arg_0 -> ((PluginResources.Builder)builder).maximumCpu(arg_0));
        Optional.of(rpcPluginResources.getMaxMemory()).ifPresent(arg_0 -> ((PluginResources.Builder)builder).maximumMemory(arg_0));
        Optional.of(rpcPluginResources.getMaxWorkers()).ifPresent(arg_0 -> ((PluginResources.Builder)builder).maximumWorkers(arg_0));
        return builder.build();
    }

    public static List<DataTransformation> transformations(List<RpcTransformation> rpcDataTransformations) {
        return rpcDataTransformations.stream().map(Unpack::transformation).collect(Collectors.toList());
    }

    private static DataTransformation transformation(RpcTransformation rpcTransformation) {
        switch (rpcTransformation.getValueCase()) {
            case RANGEDTRANSFORMATION: {
                RpcRangedTransformation rpcRangedTransformation = rpcTransformation.getRangedTransformation();
                List ranges = rpcRangedTransformation.getRangesList().stream().map(r -> new DataRange(r.getOffset(), r.getLength())).collect(Collectors.toList());
                return new RangedDataTransformation(ranges);
            }
        }
        throw new IllegalStateException("Illegal transformation type: " + rpcTransformation.getValueCase().name());
    }

    public static TraceSearcher.SearchScope searchScope(RpcSearchScope scope) {
        if (scope == null) {
            return TraceSearcher.SearchScope.PROJECT;
        }
        switch (scope) {
            case Project: {
                return TraceSearcher.SearchScope.PROJECT;
            }
            case Image: {
                return TraceSearcher.SearchScope.IMAGE;
            }
        }
        throw new IllegalArgumentException("unrecognized search scope: " + String.valueOf(scope));
    }

    private static boolean isVersionOlderThan040(RpcPluginInfo rpcPluginInfo) {
        return VersionUtil.versionInRange(VersionUtil.MINIMAL_SUPPORTED_VERSION, VersionUtil.LAST_VERSION_TO_SUPPORT_PLUGIN_INFO_NAME, Version.fromString(rpcPluginInfo.getApiVersion()));
    }

    static final class Unpacker {
        private final Map<Class<? extends Message>, Function<Message, Object>> _unpackers = new HashMap<Class<? extends Message>, Function<Message, Object>>();

        Unpacker() {
        }

        static Unpacker create() {
            return new Unpacker();
        }

        <T extends Message> Unpacker register(Class<T> message, Function<T, Object> unpacker) {
            this._unpackers.put(message, unpacker);
            return this;
        }

        Object unpack(Any any) {
            try {
                for (Map.Entry<Class<? extends Message>, Function<Message, Object>> unpacker : this._unpackers.entrySet()) {
                    Class<? extends Message> messageType = unpacker.getKey();
                    if (!any.is(messageType)) continue;
                    return unpacker.getValue().apply(any.unpack(messageType));
                }
                throw new IllegalArgumentException("unhandled type of Any: " + any.getTypeUrl());
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

