/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.main;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.hansken.plugin.extraction.main.StandaloneFlitsTest;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public final class StandaloneTestRunner {
    private static boolean _verboseEnabled = false;

    private StandaloneTestRunner(Namespace arguments) {
        Path testPath = new File(arguments.getString("testpath")).toPath();
        Path resultPath = new File(arguments.getString("resultpath")).toPath();
        Boolean regenerate = arguments.getBoolean("regenerate");
        String host = arguments.getString("host");
        Integer port = arguments.getInt("port");
        String pattern = arguments.getString("pattern");
        _verboseEnabled = arguments.getBoolean("verbose");
        StandaloneFlitsTest.setup(testPath, resultPath, regenerate, host, port, pattern);
        TestReporter testListener = new TestReporter();
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(StandaloneFlitsTest.class)}).build();
        Launcher launcher = LauncherFactory.create();
        launcher.discover(request);
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{testListener});
        launcher.execute(request, new TestExecutionListener[0]);
        System.exit(testListener.testsFailed() ? 1 : 0);
    }

    public static void main(String[] args) throws IOException {
        ArgumentParser parser = StandaloneTestRunner.argParser();
        Namespace arguments = null;
        try {
            arguments = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            System.exit(1);
        }
        new StandaloneTestRunner(arguments);
    }

    private static ArgumentParser argParser() throws IOException {
        String description = new String(StandaloneFlitsTest.class.getResourceAsStream("/description.txt").readAllBytes(), StandardCharsets.UTF_8);
        ArgumentParser parser = ArgumentParsers.newFor((String)"testframework").build().description(description);
        parser.addArgument(new String[]{"-t", "--testpath"}).metavar(new String[]{"testpath"}).required(true).help("Absolute or relative path where the test input files are stored");
        parser.addArgument(new String[]{"-r", "--resultpath"}).metavar(new String[]{"resultpath"}).required(true).help("Absolute or relative path where the test input files are stored");
        parser.addArgument(new String[]{"-g", "--regenerate"}).metavar(new String[]{"regenerate"}).type(Boolean.class).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Set if the expected test output has to be (re)generated");
        parser.addArgument(new String[]{"-m", "--host"}).metavar(new String[]{"host"}).required(true).help("Host where the extraction plugin is served");
        parser.addArgument(new String[]{"-p", "--port"}).metavar(new String[]{"port"}).type(Integer.class).required(true).help("Port where the extraction plugin is served");
        parser.addArgument(new String[]{"-i", "--pattern"}).metavar(new String[]{"pattern"}).required(false).help("Specify a pattern to run only on specific files from the test path, in the format syntax:pattern (where syntax is filesystem dependant, but at least glob and regex are supported)");
        parser.addArgument(new String[]{"-v", "--verbose"}).metavar(new String[]{"verbose"}).type(Boolean.class).required(false).action((ArgumentAction)Arguments.storeTrue()).help("Enables verbose logging.");
        return parser;
    }

    public static boolean isVerboseEnabled() {
        return _verboseEnabled;
    }

    static class TestReporter
    implements TestExecutionListener {
        private final Deque<String> _path = new ArrayDeque<String>();
        private final StringBuilder _output = new StringBuilder();
        private final AtomicInteger _passed = new AtomicInteger();
        private final AtomicInteger _failed = new AtomicInteger();

        TestReporter() {
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            System.out.println("");
            System.out.println("Test results:");
            System.out.println(this._output.toString());
            System.out.println("  " + this._passed.get() + " tests passed / " + this._failed.get() + " tests failed");
        }

        public void executionStarted(TestIdentifier testIdentifier) {
            if (testIdentifier.isContainer()) {
                this._path.add(testIdentifier.getDisplayName());
            }
            if (testIdentifier.isTest()) {
                String prefix = this._path.stream().skip(3L).collect(Collectors.joining("\\"));
                System.out.println("===== Running test: " + prefix + "\\" + testIdentifier.getDisplayName() + " ========");
            }
        }

        public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            if (testIdentifier.isContainer()) {
                this._path.removeLast();
            }
            if (testIdentifier.isTest() && testExecutionResult.getStatus() == TestExecutionResult.Status.SUCCESSFUL) {
                this.logTest(testIdentifier, testExecutionResult);
                this._passed.incrementAndGet();
            }
            if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                this.logTest(testIdentifier, testExecutionResult);
                this._failed.incrementAndGet();
                System.out.println(testExecutionResult.getThrowable().get());
                System.out.println("");
            }
            System.out.println();
        }

        private void logTest(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
            String prefix = this._path.stream().skip(3L).collect(Collectors.joining("\\"));
            this._output.append("  ");
            this._output.append(Strings.padEnd((String)(prefix + (prefix.isEmpty() ? "" : "\\") + testIdentifier.getDisplayName() + ".."), (int)50, (char)'.'));
            this._output.append(testExecutionResult.getStatus().toString());
            this._output.append("\n");
            System.out.println("Test " + String.valueOf(testExecutionResult.getStatus()));
        }

        public boolean testsFailed() {
            return this._failed.get() >= 1;
        }
    }
}

