/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nl.minvenj.nfi.flits.api.Trace;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.DefaultResultGenerator;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import org.hansken.plugin.extraction.runtime.grpc.client.PluginRunProfile;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.test.base.ProcessingUtil;

public class DefaultPluginResultGenerator
extends DefaultResultGenerator {
    public DefaultPluginResultGenerator(TraceToJson traceToJson) {
        super(traceToJson);
    }

    @Override
    public void generate(TraceResult result, Path outputPath) throws IOException {
        super.generate(result, outputPath);
        this.writeDataStreams(outputPath, result.traces());
        this.writeProfile(outputPath, result.traces());
    }

    private void createOutputFolder(Path path) {
        try {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDataStreams(Path outputPath, List<Trace> traces) throws IOException {
        for (Trace trace : traces) {
            for (String dataType : ProcessingUtil.dataTypes(trace)) {
                Path dataFile = ProcessingUtil.createDataStreamPath(outputPath, (String)trace.get("id"), dataType);
                this.createOutputFolder(dataFile);
                Files.write(dataFile, ProcessingUtil.dataStream(trace, dataType), new OpenOption[0]);
            }
            this.writeDataStreams(outputPath, trace.children().collect(Collectors.toList()));
        }
    }

    private void writeProfile(Path outputPath, List<Trace> traces) {
        traces.stream().filter(trace -> trace instanceof ClientTrace).map(trace -> (ClientTrace)trace).filter(trace -> !trace.profile().isEmpty() && (!((PluginRunProfile)trace.profile().get()).getDoubles().isEmpty() || !((PluginRunProfile)trace.profile().get()).getIntegers().isEmpty())).peek(trace -> this.createOutputFolder(ProcessingUtil.createRunProfilePath(outputPath))).forEach(trace -> this.writeProfileToFile((ClientTrace)trace, ProcessingUtil.createRunProfilePath(outputPath).toFile()));
    }

    private void writeProfileToFile(ClientTrace trace, File outputFile) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile, StandardCharsets.UTF_8));){
            writer.write("# this file contains all recorded run profiles for processing " + trace.name() + ".\n");
            writer.write("# this information can be useful when optimizing the plugins performance.\n");
            for (String line : this.profileLines((PluginRunProfile)trace.profile().get())) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private List<String> profileLines(PluginRunProfile profile) {
        ArrayList<String> profileOutput = new ArrayList<String>();
        profile.getIntegers().forEach((key, value) -> profileOutput.add(key + ": " + value));
        profile.getDoubles().forEach((key, value) -> profileOutput.add(key + ": " + value));
        Collections.sort(profileOutput);
        return profileOutput;
    }
}

