/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.hansken.plugin.extraction.api.DataWriter;
import org.hansken.plugin.extraction.api.Trace;
import org.hansken.plugin.extraction.api.transformations.DataTransformation;
import org.hansken.plugin.extraction.runtime.grpc.client.PluginRunProfile;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientTrace;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.hansken.plugin.extraction.util.ThrowingConsumer;

final class TraceDelegate {
    private TraceDelegate() {
    }

    public static EmbeddedTraceDelegate forEmbeddedTrace(Trace trace) {
        return new EmbeddedTraceDelegate(trace);
    }

    public static ClientTraceDelegate forClientTrace(ClientTrace trace) {
        return new ClientTraceDelegate(trace);
    }

    static class EmbeddedTraceDelegate
    implements nl.minvenj.nfi.flits.api.Trace,
    Trace {
        protected final List<nl.minvenj.nfi.flits.api.Trace> _children;
        private final Trace _delegate;

        EmbeddedTraceDelegate(Trace trace) {
            this._delegate = (Trace)ArgChecks.argNotNull((String)"trace", (Object)trace);
            this._children = new ArrayList<nl.minvenj.nfi.flits.api.Trace>();
        }

        public String traceId() {
            return this._delegate.traceId();
        }

        @Override
        public Set<String> types() {
            return this._delegate.types();
        }

        public Trace addType(String s) {
            this._delegate.addType(s);
            return this;
        }

        @Override
        public Set<String> properties() {
            return this._delegate.properties();
        }

        @Override
        public <T> T get(String property) {
            return (T)this._delegate.get(property);
        }

        public Trace set(String property, Object value) {
            this._delegate.set(property, value);
            return this;
        }

        public Trace addTracelet(Trace.Tracelet tracelet) {
            this._delegate.addTracelet(tracelet);
            return this;
        }

        public Trace setData(String dataType, DataWriter writer) throws IOException {
            this._delegate.setData(dataType, writer);
            return this;
        }

        public Trace setData(String dataType, List<DataTransformation> transformations) {
            this._delegate.setData(dataType, transformations);
            return this;
        }

        public Trace newChild(String name, ThrowingConsumer<Trace, IOException> enrichChildCallback) throws IOException {
            this._delegate.newChild(name, child -> {
                EmbeddedTraceDelegate delegateChild = TraceDelegate.forEmbeddedTrace(child);
                enrichChildCallback.accept((Object)delegateChild);
                this._children.add(delegateChild);
            });
            return this;
        }

        @Override
        public Stream<nl.minvenj.nfi.flits.api.Trace> children() {
            return this._children.stream();
        }
    }

    static class ClientTraceDelegate
    extends EmbeddedTraceDelegate
    implements ClientTrace {
        private final ClientTraceDelegate _parent;
        private final ClientTrace _delegate;

        ClientTraceDelegate(ClientTrace trace) {
            this(null, trace);
        }

        ClientTraceDelegate(ClientTraceDelegate parent, ClientTrace trace) {
            super((Trace)ArgChecks.argNotNull((String)"trace", (Object)trace));
            this._delegate = trace;
            this._parent = parent;
        }

        @Override
        public Trace newChild(String name, ThrowingConsumer<Trace, IOException> enrichChildCallback) {
            throw new UnsupportedOperationException("implementation of a client trace does not support creating children by using a callback");
        }

        public String name() {
            return this._delegate.name();
        }

        public ClientTrace newChild(String name) {
            return new ClientTraceDelegate(this, this._delegate.newChild(name));
        }

        public void save() {
            if (this._parent != null) {
                this._parent._children.add(this);
            }
        }

        public void close() throws Exception {
            super.close();
        }

        public void profile(PluginRunProfile profile) {
            this._delegate.profile(profile);
        }

        public Optional<PluginRunProfile> profile() {
            return this._delegate.profile();
        }
    }
}

