/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import nl.minvenj.nfi.common.argchecks.ArgChecks;
import nl.minvenj.nfi.flits.serialize.CustomConversion;
import nl.minvenj.nfi.flits.serialize.CustomMapConversion;

class PatternMatch<T> {
    private final T _value;

    private PatternMatch(T value) {
        this._value = ArgChecks.argNotNull("value", value);
    }

    static <T> PatternMatch<T> when(T value) {
        return new PatternMatch<T>(value);
    }

    <S> PatternMatch<T> matches(Class<S> type, Consumer<? super S> action) {
        ArgChecks.argNotNull("type", type);
        ArgChecks.argNotNull("action", action);
        if (type.isAssignableFrom(this._value.getClass())) {
            action.accept(type.cast(this._value));
            return new TerminalPatterMatch<T>(this._value);
        }
        return this;
    }

    PatternMatch<T> matchesAny(List<CustomConversion> customConversions, Consumer<? super String> action) {
        ArgChecks.argNotNull("customConversions", customConversions);
        ArgChecks.argNotNull("action", action);
        for (CustomConversion customConversion : customConversions) {
            Optional<String> value = customConversion.tryConvert(this._value);
            if (!value.isPresent()) continue;
            action.accept(value.get());
            return new TerminalPatterMatch<T>(this._value);
        }
        return this;
    }

    PatternMatch<T> matchesAnyMap(List<CustomMapConversion> customMaps, Consumer<? super Map<String, String>> action) {
        ArgChecks.argNotNull("customMaps", customMaps);
        ArgChecks.argNotNull("action", action);
        for (CustomMapConversion customMap : customMaps) {
            Optional<Map<String, String>> value = customMap.tryConvert(this._value);
            if (!value.isPresent()) continue;
            action.accept(value.get());
            return new TerminalPatterMatch<T>(this._value);
        }
        return this;
    }

    <X extends Throwable> void elseThrow(Function<? super T, ? extends X> throwingSupplier) throws X {
        ArgChecks.argNotNull("throwingSupplier", throwingSupplier);
        throw (Throwable)throwingSupplier.apply(this._value);
    }

    private static class TerminalPatterMatch<T>
    extends PatternMatch<T> {
        TerminalPatterMatch(T value) {
            super(value);
        }

        @Override
        public <S> PatternMatch<T> matches(Class<S> type, Consumer<? super S> action) {
            return this;
        }

        @Override
        public PatternMatch<T> matchesAny(List<CustomConversion> customConversions, Consumer<? super String> action) {
            return this;
        }

        @Override
        public PatternMatch<T> matchesAnyMap(List<CustomMapConversion> customMaps, Consumer<? super Map<String, String>> action) {
            return this;
        }

        @Override
        public <X extends Throwable> void elseThrow(Function<? super T, ? extends X> throwingSupplier) {
        }
    }
}

