/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.base;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.minvenj.nfi.flits.api.Trace;
import nl.minvenj.nfi.flits.api.result.ThrowableResult;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.DefaultResultValidator;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import org.hansken.plugin.extraction.test.base.PluginThrowableResult;
import org.hansken.plugin.extraction.test.base.ProcessingUtil;
import org.junit.jupiter.api.Assertions;

public class DefaultPluginResultValidator
extends DefaultResultValidator {
    public DefaultPluginResultValidator(TraceToJson traceToJson) {
        super(traceToJson);
    }

    @Override
    public void validate(ThrowableResult result, Path inputPath) throws IOException {
        if (!PluginThrowableResult.isValidUsingCustomMatching(result, inputPath)) {
            super.validate(result, inputPath);
        }
    }

    @Override
    public void validate(TraceResult result, Path inputPath) throws IOException {
        super.validate(result, inputPath);
        List<String> mismatches = this.findMismatches(inputPath, result.traces());
        if (!mismatches.isEmpty()) {
            Assertions.fail((String)mismatches.stream().collect(Collectors.joining(System.lineSeparator() + "\t", System.lineSeparator() + "\t", "")));
        }
    }

    private List<String> findMismatches(Path inputPath, List<Trace> traces) throws IOException {
        Assertions.assertFalse(() -> traces.size() > 1, (String)"Multiple traces are currently not supported");
        ArrayList<String> mismatches = new ArrayList<String>();
        for (Trace trace : traces) {
            mismatches.addAll(this.findMismatches(inputPath, trace));
            for (Trace childTrace : trace.children().collect(Collectors.toUnmodifiableList())) {
                mismatches.addAll(this.findMismatches(inputPath, childTrace));
            }
        }
        return mismatches;
    }

    private List<String> findMismatches(Path inputPath, Trace trace) throws IOException {
        String fileName = inputPath.getFileName().toString();
        String filePrefix = fileName.substring(0, fileName.lastIndexOf(46)) + "." + String.valueOf(trace.get("id")) + ".";
        try (Stream<Path> files = Files.list(inputPath.getParent());){
            List expectedStreams = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.getFileName().toString().startsWith(filePrefix)).collect(Collectors.toList());
            ArrayList<String> mismatches = new ArrayList<String>();
            for (Path expected : expectedStreams) {
                String dataType = expected.getFileName().toString().substring(filePrefix.length());
                if (!ProcessingUtil.hasDataStreamOfType(trace, dataType)) {
                    mismatches.add(this.dataMissingMessage(trace, dataType, expected));
                    continue;
                }
                if (Arrays.equals(ProcessingUtil.dataStream(trace, dataType), Files.readAllBytes(expected))) continue;
                mismatches.add(this.dataMismatchMessage(trace, dataType, expected));
            }
            for (String dataType : ProcessingUtil.dataTypes(trace)) {
                if (!expectedStreams.stream().noneMatch(file -> file.toString().endsWith(dataType))) continue;
                mismatches.add(this.unexpectedDataMessage(trace, dataType, ProcessingUtil.createDataStreamPath(inputPath, (String)trace.get("id"), dataType)));
            }
            ArrayList<String> arrayList = mismatches;
            return arrayList;
        }
    }

    private String unexpectedDataMessage(Trace trace, String dataType, Path dataFile) {
        return String.format(Locale.ROOT, "Trace with id '%s' contains unexpected data stream of type '%s', the expected result does not exist: %s", trace.get("id"), dataType, dataFile);
    }

    private String dataMismatchMessage(Trace trace, String dataType, Path dataFile) {
        return String.format(Locale.ROOT, "Trace with id '%s' has a data stream of type '%s' which does not equal expected data as contained in: %s", trace.get("id"), dataType, dataFile);
    }

    private String dataMissingMessage(Trace trace, String dataType, Path dataFile) {
        return String.format(Locale.ROOT, "Trace with id '%s' is missing expected data stream of type '%s', the expected result is located at: %s", trace.get("id"), dataType, dataFile);
    }
}

