package org.hansken.plugin.extraction.test.serialize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;

public class TestSearchTrace implements SearchTrace {

    private final String _traceId;
    private final Set<String> _types;
    private final Map<String, Object> _properties;
    private final Map<String, RandomAccessData> _data;

    public TestSearchTrace(final String traceId) {
        _traceId = traceId;
        _types = new HashSet<>();
        _properties = new HashMap<>();
        _data = new HashMap<>();
    }

    public TestSearchTrace(final String traceId, final Set<String> types, final Map<String, Object> properties,
                           final Map<String, RandomAccessData> data) {
        _traceId = traceId;
        _types = types;
        _properties = properties;
        _data = data;
        _properties.putIfAbsent("uid", traceId);
    }

    @Override
    public String traceId() {
        return _traceId;
    }

    @Override
    public Set<String> types() {
        return _types;
    }

    @Override
    public Set<String> properties() {
        return _properties.keySet();
    }

    @Override
    public <T> T get(final String name) {
        return (T) _properties.get(name);
    }

    @Override
    public RandomAccessData getData(final String type) {
        return _data.get(type);
    }

    @Override
    public List<String> getDataTypes() {
        return _data.keySet().stream().collect(Collectors.toList());
    }
}
