/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.serialize;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.runtime.grpc.client.api.ClientDataContext;
import org.hansken.plugin.extraction.test.base.ProcessingUtil;
import org.hansken.plugin.extraction.test.serialize.RandomAccessFileData;
import org.hansken.plugin.extraction.util.ArgChecks;

public abstract class AbstractTestContext
implements ClientDataContext {
    private final Map<String, Map<String, Path>> _idToDataTypeToPath = new HashMap<String, Map<String, Path>>();

    protected AbstractTestContext(Path tracePath) throws IOException {
        ArgChecks.argNotNull((String)"tracePath", (Object)tracePath);
        this.fillData(tracePath);
    }

    private void fillData(Path tracePath) throws IOException {
        Path searchTracesPath = ProcessingUtil.getSearchTracesPath(tracePath);
        if (!Files.exists(searchTracesPath, new LinkOption[0])) {
            return;
        }
        Map<Path, String> filenameToId = AbstractTestContext.mapFilenamesToTraceId(searchTracesPath);
        for (Map.Entry<Path, String> entry : filenameToId.entrySet()) {
            String traceId = entry.getValue();
            String name = ProcessingUtil.extractFileName(entry.getKey());
            Map<String, Path> dataTypeToPath = AbstractTestContext.mapDataTypeToPath(searchTracesPath, name);
            this._idToDataTypeToPath.put(traceId, dataTypeToPath);
        }
    }

    private static Map<String, Path> mapDataTypeToPath(Path searchTracesPath, String name) throws IOException {
        try (Stream<Path> files = Files.list(searchTracesPath);){
            Map<String, Path> map = files.filter(path -> ProcessingUtil.extractFileName(path).equals(name)).collect(Collectors.toMap(ProcessingUtil::extractFileExtension, Function.identity()));
            return map;
        }
    }

    private static Map<Path, String> mapFilenamesToTraceId(Path searchTracesPath) throws IOException {
        try (Stream<Path> files = Files.list(searchTracesPath);){
            Map<Path, String> map = files.filter(path -> ProcessingUtil.isFileWithExtension(path, "trace")).collect(Collectors.toMap(Path::getFileName, path -> ProcessingUtil.searchTraceFromPath(path).traceId()));
            return map;
        }
    }

    public RandomAccessData data(String traceId, String dataType) {
        ArgChecks.argNotNull((String)"traceId", (Object)traceId);
        ArgChecks.argNotNull((String)"dataType", (Object)dataType);
        try {
            return new RandomAccessFileData(this._idToDataTypeToPath.get(traceId).get(dataType).toFile());
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

