/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import nl.minvenj.nfi.common.argchecks.ArgChecks;

public final class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static <T> T uncheckedIO(IOSupplier<T> supplier) {
        ArgChecks.argNotNull("supplier", supplier);
        try {
            return supplier.get();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void uncheckedIO(IORunnable runnable) {
        ArgChecks.argNotNull("runnable", runnable);
        ExceptionUtil.uncheckedIO(() -> {
            runnable.run();
            return null;
        });
    }

    public static interface IORunnable {
        public void run() throws IOException;
    }

    public static interface IOSupplier<T> {
        public T get() throws IOException;
    }
}

