/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.common.argchecks;

import java.util.Locale;

public final class ArgChecks {
    private ArgChecks() {
    }

    public static <T> T argNotNull(String name, T value) {
        if (value == null) {
            throw new NullPointerException(String.format(Locale.ROOT, "Argument '%s' cannot be null", name));
        }
        return value;
    }

    public static String argNotEmpty(String name, String value) {
        ArgChecks.argNotNull(name, value);
        if (value.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' cannot be empty", name));
        }
        return value;
    }

    public static <T extends Iterable<?>> T argNotEmpty(String name, T value) {
        ArgChecks.argNotNull(name, value);
        if (!value.iterator().hasNext()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' cannot be empty", name));
        }
        return value;
    }

    public static int argNotNegative(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' cannot be negative: %d", name, value));
        }
        return value;
    }

    public static long argNotNegative(String name, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' cannot be negative: %d", name, value));
        }
        return value;
    }

    public static double argNotNegative(String name, double value) {
        if (Double.isNaN(value) || Double.compare(value, 0.0) < 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' cannot be negative: %f", name, value));
        }
        return value;
    }

    public static <T extends Comparable<T>> T argBetween(String name, T value, T minInclusive, T maxInclusive) {
        ArgChecks.argNotNull("value", value);
        ArgChecks.argNotNull("minInclusive", minInclusive);
        ArgChecks.argNotNull("maxInclusive", maxInclusive);
        if (minInclusive.compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Minimum value (%s) larger than maximum value (%s)", minInclusive, maxInclusive));
        }
        if (value.compareTo(minInclusive) < 0 || value.compareTo(maxInclusive) > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' not in [%s..%s]: %s", name, minInclusive, maxInclusive, value));
        }
        return value;
    }

    public static int argBetween(String name, int value, int minInclusive, int maxInclusive) {
        if (minInclusive > maxInclusive) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Minimum value (%d) larger than maximum value (%d)", minInclusive, maxInclusive));
        }
        if (value < minInclusive || value > maxInclusive) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' not in [%d..%d]: %d", name, minInclusive, maxInclusive, value));
        }
        return value;
    }

    public static long argBetween(String name, long value, long minInclusive, long maxInclusive) {
        if (minInclusive > maxInclusive) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Minimum value (%d) larger than maximum value (%d)", minInclusive, maxInclusive));
        }
        if (value < minInclusive || value > maxInclusive) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Argument '%s' not in [%d..%d]: %d", name, minInclusive, maxInclusive, value));
        }
        return value;
    }

    public static void validateBufferArgs(int bufferLength, int offset, int count) {
        if (bufferLength < 0) {
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Buffer length cannot be negative: %d", bufferLength));
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Offset cannot be negative: %d", offset));
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "Count cannot be negative: %d", count));
        }
        if (offset + count > bufferLength) {
            throw new IndexOutOfBoundsException(String.format(Locale.ROOT, "offset+count (%d) out of range for buffer of size %d", offset + count, bufferLength));
        }
    }

    public static void validateBufferArgs(byte[] buffer, int offset, int count) {
        ArgChecks.argNotNull("buffer", buffer);
        ArgChecks.validateBufferArgs(buffer.length, offset, count);
    }
}

