/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.serialize;

import java.util.HashMap;
import java.util.Map;
import nl.minvenj.nfi.flits.serialize.Property;

final class MapUtil {
    private static final String ROOT_ELEMENT = "ROOT_ELEMENT.";

    private MapUtil() {
    }

    static Map<String, Object> mapMap(Map<Property, Object> input) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<Property, Object> entry : input.entrySet()) {
            Property property = entry.getKey();
            Object value = entry.getValue();
            String rootKey = ROOT_ELEMENT + property.type();
            Map<String, Object> nested = MapUtil.buildFullNestedMap(property.name(), value);
            MapUtil.mergeInto(result, rootKey, nested);
        }
        return result;
    }

    private static Map<String, Object> buildFullNestedMap(String processPropertyName, Object value) {
        if (processPropertyName == null || processPropertyName.isEmpty()) {
            return new HashMap<String, Object>();
        }
        int dotIndex = processPropertyName.indexOf(46);
        if (dotIndex < 0) {
            HashMap<String, Object> leafMap = new HashMap<String, Object>();
            leafMap.put(processPropertyName, value);
            return leafMap;
        }
        String propertyType = processPropertyName.substring(0, dotIndex);
        String propertyName = processPropertyName.substring(dotIndex + 1);
        Map<String, Object> tailMap = MapUtil.buildFullNestedMap(propertyName, value);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(propertyType, tailMap);
        return map;
    }

    private static void mergeInto(Map<String, Object> target, String rootKey, Map<String, Object> nestedMap) {
        if (!target.containsKey(rootKey)) {
            target.put(rootKey, new HashMap<String, Object>(nestedMap));
            return;
        }
        Object existing = target.get(rootKey);
        if (existing instanceof Map) {
            MapUtil.mergeNestedMaps((Map)existing, nestedMap);
        } else {
            target.put(rootKey, new HashMap<String, Object>(nestedMap));
        }
    }

    private static void mergeNestedMaps(Map<String, Object> target, Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object sourceValue = entry.getValue();
            if (target.containsKey(key)) {
                Object targetValue = target.get(key);
                if (targetValue instanceof Map && sourceValue instanceof Map) {
                    MapUtil.mergeNestedMaps((Map)targetValue, (Map)sourceValue);
                    continue;
                }
                if (targetValue instanceof Map) continue;
                target.put(key, sourceValue);
                continue;
            }
            target.put(key, sourceValue);
        }
    }

    static String getMapNamePostfix(Property property) {
        int beginIndex = property.fullName().indexOf(".");
        return property.fullName().substring(beginIndex + 1);
    }
}

