/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.test.serialize;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.hansken.plugin.extraction.api.RandomAccessData;
import org.hansken.plugin.extraction.api.SearchTrace;

public class TestSearchTrace
implements SearchTrace {
    private final String _traceId;
    private final Set<String> _types;
    private final Map<String, Object> _properties;
    private final Map<String, RandomAccessData> _data;

    public TestSearchTrace(String traceId) {
        this._traceId = traceId;
        this._types = new HashSet<String>();
        this._properties = new HashMap<String, Object>();
        this._data = new HashMap<String, RandomAccessData>();
    }

    public TestSearchTrace(String traceId, Set<String> types, Map<String, Object> properties, Map<String, RandomAccessData> data) {
        this._traceId = traceId;
        this._types = types;
        this._properties = properties;
        this._data = data;
        this._properties.putIfAbsent("uid", traceId);
    }

    public String traceId() {
        return this._traceId;
    }

    public Set<String> types() {
        return this._types;
    }

    public Set<String> properties() {
        return this._properties.keySet();
    }

    public <T> T get(String name) {
        return (T)this._properties.get(name);
    }

    public RandomAccessData getData(String type) {
        return this._data.get(type);
    }

    public List<String> getDataTypes() {
        return this._data.keySet().stream().collect(Collectors.toList());
    }
}

