/*
 * Decompiled with CFR 0.152.
 */
package org.hansken.plugin.extraction.runtime.grpc.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.hansken.plugin.extraction.runtime.grpc.common.Version;
import org.hansken.plugin.extraction.util.ArgChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionUtil {
    static final Version MINIMAL_SUPPORTED_VERSION = new Version(0, 2, 0);
    static final Version LAST_VERSION_TO_SUPPORT_PLUGIN_INFO_NAME = Version.fromString("0.3.0");
    private static final Logger LOG = LoggerFactory.getLogger(VersionUtil.class);
    private static final Version RUNTIME_VERSION = Version.fromString(VersionUtil.getApiVersion());
    private static String _apiVersion;

    private VersionUtil() {
    }

    public static String getApiVersion() {
        if (_apiVersion == null) {
            _apiVersion = ArgChecks.argNotEmpty((String)"apiVersion", (String)VersionUtil.readApiVersion());
        }
        return _apiVersion;
    }

    public static boolean isCompatible(String pluginVersionString) {
        if (pluginVersionString == null || pluginVersionString.isEmpty()) {
            LOG.debug("plugin version is not compatible: plugin version information is missing");
            return false;
        }
        Version pluginVersion = Version.fromString(pluginVersionString);
        if (VersionUtil.minVersionIsCurrentSnapshot()) {
            Version pluginVersionAsSnapshot = new Version(pluginVersion.getMajorVersion(), pluginVersion.getMinorVersion(), pluginVersion.getPatchVersion(), RUNTIME_VERSION.getSubVersion());
            return VersionUtil.versionInRange(RUNTIME_VERSION, RUNTIME_VERSION, pluginVersionAsSnapshot);
        }
        return VersionUtil.versionInRange(MINIMAL_SUPPORTED_VERSION, RUNTIME_VERSION, pluginVersion);
    }

    public static boolean isHigherOrEqualTo(String first, String second) {
        ArgChecks.argNotEmpty((String)"first", (String)first);
        ArgChecks.argNotEmpty((String)"second", (String)second);
        Version firstVersion = Version.fromString(first);
        Version secondVersion = Version.fromString(second);
        return firstVersion.isHigherOrEqualTo(secondVersion);
    }

    static boolean versionInRange(Version minVersion, Version maxVersion, Version pluginVersion) {
        if (maxVersion.isHigherOrEqualTo(pluginVersion) && pluginVersion.isHigherOrEqualTo(minVersion)) {
            LOG.debug("plugin version (" + String.valueOf(pluginVersion) + ") is in range of compatible versions [" + String.valueOf(minVersion) + ", " + String.valueOf(maxVersion) + "]");
            return true;
        }
        LOG.debug("plugin version (" + String.valueOf(pluginVersion) + ") is not in range of compatible versions [" + String.valueOf(minVersion) + ", " + String.valueOf(maxVersion) + "]");
        return false;
    }

    private static boolean minVersionIsCurrentSnapshot() {
        return !RUNTIME_VERSION.getSubVersion().isEmpty() && MINIMAL_SUPPORTED_VERSION.equals(new Version(RUNTIME_VERSION.getMajorVersion(), RUNTIME_VERSION.getMinorVersion(), RUNTIME_VERSION.getPatchVersion()));
    }

    private static String readApiVersion() {
        String string;
        block8: {
            InputStream resourceAsStream = VersionUtil.class.getResourceAsStream("/apiversion.properties");
            try {
                Properties properties = new Properties();
                properties.load(resourceAsStream);
                string = properties.getProperty("api.version");
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            resourceAsStream.close();
        }
        return string;
    }
}

