/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.collection.AbstractCollectionDecorator;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.map.AbstractMapDecorator;

public class PredicatedMap
extends AbstractMapDecorator {
    protected final Predicate keyPredicate;
    protected final Predicate valuePredicate;

    public static Map decorate(Map map, Predicate keyPredicate, Predicate valuePredicate) {
        return new PredicatedMap(map, keyPredicate, valuePredicate);
    }

    protected PredicatedMap(Map map, Predicate keyPredicate, Predicate valuePredicate) {
        super(map);
        this.keyPredicate = keyPredicate;
        this.valuePredicate = valuePredicate;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.validate(key, value);
        }
    }

    protected void validate(Object key, Object value) {
        if (this.keyPredicate != null && !this.keyPredicate.evaluate(key)) {
            throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
        }
        if (this.valuePredicate != null && !this.valuePredicate.evaluate(value)) {
            throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
        }
    }

    public Object put(Object key, Object value) {
        this.validate(key, value);
        return this.map.put(key, value);
    }

    public void putAll(Map mapToCopy) {
        Iterator it = mapToCopy.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            this.validate(key, value);
        }
        this.map.putAll(mapToCopy);
    }

    public Set entrySet() {
        if (this.valuePredicate == null) {
            return this.map.entrySet();
        }
        return new PredicatedMapEntrySet(this.map.entrySet(), this.valuePredicate);
    }

    static class PredicatedMapEntry
    extends AbstractMapEntryDecorator {
        private final Predicate predicate;

        protected PredicatedMapEntry(Map.Entry entry, Predicate valuePredicate) {
            super(entry);
            this.predicate = valuePredicate;
        }

        public Object setValue(Object obj) {
            if (this.predicate != null && !this.predicate.evaluate(obj)) {
                throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
            }
            return this.entry.setValue(obj);
        }
    }

    static class PredicatedMapEntrySetIterator
    extends AbstractIteratorDecorator {
        private final Predicate valuePredicate;

        protected PredicatedMapEntrySetIterator(Iterator iterator, Predicate valuePredicate) {
            super(iterator);
            this.valuePredicate = valuePredicate;
        }

        public Object next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new PredicatedMapEntry(entry, this.valuePredicate);
        }
    }

    static class PredicatedMapEntrySet
    extends AbstractCollectionDecorator
    implements Set {
        private final Predicate valuePredicate;

        protected PredicatedMapEntrySet(Set set, Predicate valuePred) {
            super(set);
            this.valuePredicate = valuePred;
        }

        public Iterator iterator() {
            return new PredicatedMapEntrySetIterator(this.collection.iterator(), this.valuePredicate);
        }

        public Object[] toArray() {
            Object[] array = this.collection.toArray();
            int i = 0;
            while (i < array.length) {
                array[i] = new PredicatedMapEntry((Map.Entry)array[i], this.valuePredicate);
                ++i;
            }
            return array;
        }

        public Object[] toArray(Object[] array) {
            Object[] result = array;
            if (array.length > 0) {
                result = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
            }
            result = this.collection.toArray(result);
            int i = 0;
            while (i < result.length) {
                result[i] = new PredicatedMapEntry((Map.Entry)result[i], this.valuePredicate);
                ++i;
            }
            if (result.length > array.length) {
                return result;
            }
            System.arraycopy(result, 0, array, 0, result.length);
            if (array.length > result.length) {
                array[result.length] = null;
            }
            return array;
        }
    }
}

