/*
 * Decompiled with CFR 0.152.
 */
package nl.minvenj.nfi.flits.base;

import com.fasterxml.jackson.core.JsonGenerator;
import java.util.Optional;
import nl.minvenj.nfi.flits.api.result.TraceResult;
import nl.minvenj.nfi.flits.base.FlitsResultJson;
import nl.minvenj.nfi.flits.serialize.TraceToJson;
import nl.minvenj.nfi.flits.util.ExceptionUtil;

final class TraceResultJson
implements FlitsResultJson {
    private final TraceResult _result;
    private final TraceToJson _traceToJson;

    public TraceResultJson(TraceResult result, TraceToJson traceToJson) {
        this._result = result;
        Optional<String> factoryName = this._result.factoryName();
        this._traceToJson = factoryName.isEmpty() ? traceToJson : traceToJson.setFactoryName(factoryName.get());
    }

    @Override
    public void toGenerator(JsonGenerator generator) {
        ExceptionUtil.uncheckedIO(() -> {
            try {
                this._traceToJson.writeToGenerator(this._result.traces(), generator);
            }
            finally {
                generator.flush();
            }
        });
    }
}

