/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.actions.aerogear.listener;

import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.hawkular.actions.api.log.MsgLogger;
import org.hawkular.actions.api.model.ActionMessage;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.aerogear.unifiedpush.DefaultPushSender;
import org.jboss.aerogear.unifiedpush.PushSender;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="actionPlugin like 'aerogear'")})
public class AerogearListener
extends BasicMessageListener<ActionMessage> {
    static final String ROOT_SERVER_URL_PROPERTY = "org.hawkular.actions.aerogear.root.server.url";
    static final String ROOT_SERVER_URL = System.getProperty("org.hawkular.actions.aerogear.root.server.url");
    static final String APPLICATION_ID_PROPERTY = "org.hawkular.actions.aerogear.application.id";
    static final String APPLICATION_ID = System.getProperty("org.hawkular.actions.aerogear.application.id");
    static final String MASTER_SECRET_PROPERTY = "org.hawkular.actions.aerogear.master.secret";
    static final String MASTER_SECRET = System.getProperty("org.hawkular.actions.aerogear.master.secret");
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    PushSender pushSender;

    @PostConstruct
    void setup() {
        if (this.isBlank(ROOT_SERVER_URL) || this.isBlank(APPLICATION_ID) || this.isBlank(MASTER_SECRET)) {
            String msg = "Configure org.hawkular.actions.aerogear.root.server.url, org.hawkular.actions.aerogear.application.id and org.hawkular.actions.aerogear.master.secret";
            this.msgLog.errorCannotBeStarted("aerogear", msg);
            return;
        }
        try {
            this.pushSender = DefaultPushSender.withRootServerURL((String)ROOT_SERVER_URL).pushApplicationId(APPLICATION_ID).masterSecret(MASTER_SECRET).build();
        }
        catch (Exception e) {
            this.msgLog.errorCannotBeStarted("aerogear", e.getLocalizedMessage());
        }
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private String prepareMessage(ActionMessage msg) {
        String preparedMsg = null;
        if (msg != null) {
            Alert alert;
            Alert alert2 = alert = msg.getAlert() != null ? (Alert)JsonUtil.fromJson((String)msg.getAlert(), Alert.class) : null;
            if (alert != null) {
                preparedMsg = "Alert : " + alert.getTriggerId() + " at " + alert.getCtime() + " -- Severity: " + alert.getSeverity().toString();
            } else if (msg.getMessage() != null) {
                preparedMsg = msg.getMessage();
            } else {
                preparedMsg = "Message received without data at " + System.currentTimeMillis();
                this.msgLog.warnMessageReceivedWithoutPayload("aerogear");
            }
        }
        return preparedMsg;
    }

    protected void onBasicMessage(ActionMessage msg) {
        String alias;
        this.msgLog.infoActionReceived("aerogear", msg.toString());
        if (this.pushSender == null) {
            this.msgLog.errorCannotSendMessage("aerogear", "Plugin is not started");
            return;
        }
        UnifiedMessage.MessageBuilder alert = UnifiedMessage.withMessage().alert(this.prepareMessage(msg));
        if (msg.getProperties() != null && !this.isBlank(alias = (String)msg.getProperties().get("alias"))) {
            alert.config().criteria().aliases(new String[]{alias});
        }
        UnifiedMessage unifiedMessage = alert.build();
        this.pushSender.send(unifiedMessage);
    }
}

