/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.external.metrics;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import org.jboss.logging.Logger;

public class CassCluster {
    private static final Logger log = Logger.getLogger(CassCluster.class);
    private static final String ALERTS_CASSANDRA_PORT = "hawkular-alerts-metrics.cassandra-cql-port";
    private static final String ALERTS_CASSANDRA_NODES = "hawkular-alerts-metrics.cassandra-nodes";
    private static final String ALERTS_CASSANDRA_RETRY_ATTEMPTS = "hawkular-alerts-metrics.cassandra-retry-attempts";
    private static final String ALERTS_CASSANDRA_RETRY_TIMEOUT = "hawkular-alerts-metrics.cassandra-retry-timeout";
    private static Cluster cluster = null;
    private static Session session = null;

    private CassCluster() {
    }

    public static Session getSession() throws Exception {
        if (cluster == null && session == null) {
            String cqlPort = System.getProperty(ALERTS_CASSANDRA_PORT, "9042");
            String nodes = System.getProperty(ALERTS_CASSANDRA_NODES, "127.0.0.1");
            int attempts = Integer.parseInt(System.getProperty(ALERTS_CASSANDRA_RETRY_ATTEMPTS, "5"));
            int timeout = Integer.parseInt(System.getProperty(ALERTS_CASSANDRA_RETRY_TIMEOUT, "2000"));
            while (session == null && !Thread.currentThread().isInterrupted() && attempts >= 0) {
                block6: {
                    try {
                        cluster = new Cluster.Builder().addContactPoints(nodes.split(",")).withPort(new Integer(cqlPort).intValue()).withProtocolVersion(ProtocolVersion.V3).build();
                        session = cluster.connect();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Could not connect to Cassandra cluster - assuming is not up yet. Cause: " + (e.getCause() == null ? e : e.getCause())));
                        if (attempts != 0) break block6;
                        throw e;
                    }
                }
                if (session != null) continue;
                log.warn((Object)("[" + attempts + "] Retrying connecting to Cassandra cluster in [" + timeout + "]ms..."));
                --attempts;
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        return session;
    }

    public static void shutdown() {
        if (session != null && !session.isClosed()) {
            session.close();
        }
    }
}

