/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.sms.listener;

import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.factory.MessageFactory;
import com.twilio.sdk.resource.instance.Account;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicNameValuePair;
import org.hawkular.alerts.actions.api.log.MsgLogger;
import org.hawkular.alerts.actions.api.model.ActionMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="actionPlugin like 'sms'")})
public class SmsListener
extends BasicMessageListener<ActionMessage> {
    static final String ACCOUNT_SID_PROPERTY = "org.hawkular.actions.sms.sid";
    static final String ACCOUNT_SID = System.getProperty("org.hawkular.actions.sms.sid");
    static final String AUTH_TOKEN_PROPERTY = "org.hawkular.actions.sms.token";
    static final String AUTH_TOKEN = System.getProperty("org.hawkular.actions.sms.token");
    static final String FROM_PROPERTY = "org.hawkular.actions.sms.from";
    static final String FROM = System.getProperty("org.hawkular.actions.sms.from");
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    MessageFactory messageFactory;

    @PostConstruct
    void setup() {
        if (StringUtils.isBlank((CharSequence)ACCOUNT_SID) || StringUtils.isBlank((CharSequence)AUTH_TOKEN)) {
            String msg = "Configure org.hawkular.actions.sms.sid and org.hawkular.actions.sms.token";
            this.msgLog.errorCannotBeStarted("sms", msg);
            return;
        }
        try {
            TwilioRestClient client = new TwilioRestClient(ACCOUNT_SID, AUTH_TOKEN);
            Account account = client.getAccount();
            this.messageFactory = account.getMessageFactory();
        }
        catch (Exception e) {
            this.msgLog.errorCannotBeStarted("sms", e.getLocalizedMessage());
        }
    }

    protected void onBasicMessage(ActionMessage msg) {
        this.msgLog.infoActionReceived("sms", msg.toString());
        if (this.messageFactory == null) {
            this.msgLog.errorCannotSendMessage("sms", "Plugin is not started");
            return;
        }
        Map properties = msg.getProperties();
        if (properties == null || properties.isEmpty()) {
            this.msgLog.errorCannotSendMessage("sms", "Missing message properties");
            return;
        }
        String to = (String)properties.get("phone");
        if (StringUtils.isBlank((CharSequence)to)) {
            this.msgLog.errorCannotSendMessage("sms", "Missing recipient");
            return;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(3);
        params.add(new BasicNameValuePair("To", to));
        params.add(new BasicNameValuePair("From", FROM));
        params.add(new BasicNameValuePair("Body", msg.getMessage()));
        try {
            this.messageFactory.create(params);
        }
        catch (TwilioRestException e) {
            this.msgLog.errorCannotSendMessage("sms", e.getLocalizedMessage());
        }
    }
}

